package com.bxm.warcar.datasync.client.cache;

/**
 * @author allen
 * @date 2019/4/3
 * @since 1.0.0
 */
public interface MutableCache extends Cache {

    /**
     * 设置对象到缓存中
     * @param key 保存的key
     * @param value value
     * @return 返回修改前的旧对象
     * @throws NullPointerException NPE
     */
    @Deprecated
    default Object set(String key, Object value) throws NullPointerException {
        return set(key, value, value.getClass());
    }

    /**
     * 设置对象到缓存中
     * @param key 保存的key
     * @param value value
     * @param clazz 缓存类
     * @return 返回修改前的旧对象
     * @throws NullPointerException NPE
     */
    Object set(String key, Object value, Class<?> clazz) throws NullPointerException;

    /**
     * 清空指定key的缓存
     * @param key key
     */
    @Deprecated
    default void del(String key) {
        del(key, null);
    }

    /**
     * 清空指定key的缓存
     * @param key 缓存key
     * @param clazz 缓存类
     */
    void del(String key, Class<?> clazz);
}
