/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.datasync.client.actions;

import com.bxm.warcar.datasync.client.Action;
import com.bxm.warcar.datasync.client.cache.MutableCache;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheAction
implements Action {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheAction.class);
    private final MutableCache mutableCache;

    public CacheAction(MutableCache mutableCache) {
        Preconditions.checkNotNull((Object)mutableCache);
        this.mutableCache = mutableCache;
    }

    @Override
    public void add(String key, Object value) {
        this.add(key, value, value.getClass());
    }

    @Override
    public void update(String key, Object value) {
        this.update(key, value, value.getClass());
    }

    @Override
    public void remove(String key) {
        this.remove(key, null);
    }

    @Override
    public void add(String key, Object value, Class<?> clazz) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"value");
        this.mutableCache.set(key, value, clazz);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added cache: {}", (Object)key);
        }
    }

    @Override
    public void update(String key, Object value, Class<?> clazz) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"value");
        this.mutableCache.set(key, value, clazz);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("updated cache: {}", (Object)key);
        }
    }

    @Override
    public void remove(String key, Class<?> clazz) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)key), (Object)"key");
        this.mutableCache.del(key, clazz);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("deleted cache: {}", (Object)key);
        }
    }
}

