package com.bxm.warcar.datasync.serialization;

import com.bxm.warcar.utils.JsonHelper;

/**
 * @author allen
 * @date 2019/4/8
 * @since 1.0.0
 */
public interface Serialization {

    default String serialize(Object value) {
        return JsonHelper.convert(value);
    }

    default <T> T deserialize(String value, Class<T> cls) {
        return JsonHelper.convert(value, cls);
    }
}
