/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class PluginManagerImpl
implements PluginManager,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManagerImpl.class);
    private final ConcurrentHashMap<String, Plugin> plugins = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> errorContext = new ConcurrentHashMap();

    @Override
    public Plugin find(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"plugin name is null");
        return this.plugins.get(name);
    }

    @Override
    public List<Plugin> getPlugins() {
        return ImmutableList.copyOf(this.plugins.values());
    }

    @Override
    public Plugin register(Plugin plugin) {
        Preconditions.checkNotNull((Object)plugin);
        return this.plugins.put(plugin.getName(), plugin);
    }

    @Override
    public Plugin remove(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name), (Object)"plugin name is null");
        return this.plugins.remove(name);
    }

    @Override
    public Map<String, String> getErrorPluginContext() {
        return this.errorContext;
    }

    public void destroy() throws Exception {
        Collection<Plugin> plugins = this.plugins.values();
        for (Plugin plugin : plugins) {
            try {
                plugin.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy plugin: " + plugin.getName(), (Throwable)e);
            }
        }
        plugins.clear();
    }
}

