/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.hotswap;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginConfig;
import com.bxm.warcar.dpl.PluginLoader;
import com.bxm.warcar.dpl.PluginManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractPluginRefreshScheduler
implements InitializingBean,
DisposableBean,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPluginRefreshScheduler.class);
    private static final int DEFAULT_INITIAL_DELAY = 5;
    private static final int DEFAULT_REFRESH_DELAY = 1;
    private int initialDelay = 5;
    private int refreshDelay = 1;
    private ScheduledExecutorService scheduledExecutor;
    private final PluginManager pluginManager;
    private final PluginLoader pluginLoader;

    public AbstractPluginRefreshScheduler(PluginManager pluginManager, PluginLoader pluginLoader) {
        this.pluginManager = pluginManager;
        this.pluginLoader = pluginLoader;
    }

    public void afterPropertiesSet() throws Exception {
        this.refreshPluginConfigs();
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("plugin_refresh-schedule-pool-%d").daemon(true).build());
        this.scheduledExecutor.scheduleWithFixedDelay(this, this.initialDelay, this.refreshDelay, TimeUnit.SECONDS);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("AbstractPluginRefreshScheduler start");
        }
    }

    public void destroy() throws Exception {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdownNow();
        }
    }

    @Override
    public void run() {
        try {
            this.refreshPluginConfigs();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to refresh plugin configs", e);
        }
    }

    public abstract List<PluginConfig> queryPluginConfigs();

    private void refreshPluginConfigs() {
        Map<String, PluginConfig> moduleConfigs = this.indexPluginConfigByModuleName(this.filterEnabledModule());
        Map<String, String> configVersions = this.transformToConfigVersions(moduleConfigs);
        Map<String, String> moduleVersions = this.transformToModuleVersions(this.pluginManager.getPlugins());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Config size: {}", (Object)configVersions.size());
            LOGGER.debug("Plugin size: {}", (Object)moduleVersions.size());
            LOGGER.debug("now in map {}", moduleVersions);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Config versions: {}", configVersions);
            LOGGER.debug("Plugin versions: {}", moduleVersions);
        }
        MapDifference difference = Maps.difference(configVersions, moduleVersions);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Version difference: {}", (Object)difference);
        }
        this.putPlugins(moduleConfigs, this.configAdds((MapDifference<String, String>)difference));
        this.putPlugins(moduleConfigs, this.configDifference((MapDifference<String, String>)difference));
        this.removeModules(this.pluginsRedundant((MapDifference<String, String>)difference));
    }

    private Collection<PluginConfig> filterEnabledModule() {
        List<PluginConfig> pluginConfigs = this.queryPluginConfigs();
        if (pluginConfigs == null || pluginConfigs.isEmpty()) {
            return new ArrayList<PluginConfig>();
        }
        return Collections2.filter(pluginConfigs, (Predicate)new Predicate<PluginConfig>(){

            public boolean apply(PluginConfig moduleConfig) {
                return moduleConfig.isEnabled();
            }
        });
    }

    private void putPlugins(Map<String, PluginConfig> pluginConfigs, Set<String> pluginNames) {
        for (String name : pluginNames) {
            PluginConfig pluginConfig = pluginConfigs.get(name);
            try {
                if (this.isFailedVersion(pluginConfig)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("this version is failed, ignore.{}", (Object)pluginConfig);
                    continue;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Load plugin config: {}", (Object)pluginConfig);
                }
                Plugin plugin = this.pluginLoader.load(pluginConfig);
                Plugin removed = this.pluginManager.register(plugin);
                AbstractPluginRefreshScheduler.destroyQuietly(removed);
                this.pluginManager.getErrorPluginContext().remove(name.toUpperCase(Locale.CHINESE));
                this.pluginManager.getErrorPluginContext().remove(name.toUpperCase(Locale.CHINESE) + "_ERROR");
            }
            catch (Exception e) {
                this.pluginManager.getErrorPluginContext().put(name.toUpperCase(Locale.CHINESE) + "_ERROR", ToStringBuilder.reflectionToString((Object)e));
                this.pluginManager.getErrorPluginContext().put(name.toUpperCase(Locale.CHINESE), pluginConfig.getVersion());
                LOGGER.error("Failed to load plugin config: " + pluginConfig, (Throwable)e);
            }
            catch (Error e) {
                LOGGER.error("Failed to load plugin config: " + pluginConfig, (Throwable)e);
            }
        }
    }

    private boolean isFailedVersion(PluginConfig pluginConfig) {
        Preconditions.checkNotNull((Object)pluginConfig, (Object)"pluginConfig is null");
        String name = pluginConfig.getName();
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        String version = this.pluginManager.getErrorPluginContext().get(name.toUpperCase(Locale.CHINESE));
        return pluginConfig.getVersion().equals(version);
    }

    private void removeModules(Set<String> pluginsRedundant) {
        for (String name : pluginsRedundant) {
            Plugin removed = this.pluginManager.remove(name);
            AbstractPluginRefreshScheduler.destroyQuietly(removed);
        }
    }

    private static void destroyQuietly(Plugin module) {
        if (module != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Destroy plugin: {}", (Object)module.getName());
                }
                module.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy plugin " + module, (Throwable)e);
            }
        }
    }

    private Set<String> pluginsRedundant(MapDifference<String, String> difference) {
        return difference.entriesOnlyOnRight().keySet();
    }

    private Set<String> configDifference(MapDifference<String, String> difference) {
        return difference.entriesDiffering().keySet();
    }

    private Set<String> configAdds(MapDifference<String, String> difference) {
        return difference.entriesOnlyOnLeft().keySet();
    }

    private Map<String, String> transformToModuleVersions(List<Plugin> modules) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)Maps.uniqueIndex(modules, (Function)new Function<Plugin, String>(){

            public String apply(Plugin input) {
                return input.getName();
            }
        }), (Function)new Function<Plugin, String>(){

            public String apply(Plugin input) {
                return input.getVersion();
            }
        }));
    }

    private Map<String, String> transformToConfigVersions(Map<String, PluginConfig> moduleConfigs) {
        return ImmutableMap.copyOf((Map)Maps.transformValues(moduleConfigs, (Function)new Function<PluginConfig, String>(){

            public String apply(PluginConfig input) {
                return input.getVersion();
            }
        }));
    }

    private Map<String, PluginConfig> indexPluginConfigByModuleName(Collection<PluginConfig> list) {
        return ImmutableMap.copyOf((Map)Maps.uniqueIndex(list, (Function)new Function<PluginConfig, String>(){

            public String apply(PluginConfig input) {
                return input.getName();
            }
        }));
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public void setRefreshDelay(int refreshDelay) {
        this.refreshDelay = refreshDelay;
    }
}

