/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.hotswap;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginClassLoader.class);
    public static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "javax.", "sun.", "oracle."};
    private final Set<String> excludedPackages = new HashSet<String>();
    private final List<String> overridePackages;

    public PluginClassLoader(List<URL> urls, ClassLoader parent, List<String> overridePackages) {
        super(urls.toArray(new URL[0]), parent);
        this.overridePackages = overridePackages;
        this.excludedPackages.addAll(Sets.newHashSet((Object[])DEFAULT_EXCLUDED_PACKAGES));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        Class<PluginClassLoader> clazz = PluginClassLoader.class;
        synchronized (PluginClassLoader.class) {
            if (this.isEligibleForOverriding(name)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Load class for overriding: {}", (Object)name);
                }
                result = this.loadClassForOverriding(name);
            }
            if (result != null) {
                if (resolve) {
                    this.resolveClass(result);
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return super.loadClass(name, resolve);
        }
    }

    private Class<?> loadClassForOverriding(String name) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            result = this.findClass(name);
        }
        return result;
    }

    private boolean isEligibleForOverriding(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        return !this.isExcluded(name) && Iterables.any(this.overridePackages, (Predicate)new Predicate<String>(){

            public boolean apply(String prefix) {
                return name.startsWith(prefix);
            }
        });
    }

    protected boolean isExcluded(String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className is null");
        for (String packageName : this.excludedPackages) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }
}

