/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.dir;

import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.PluginRuntimeException;
import com.bxm.warcar.dpl2.dir.PluginChangedEvent;
import com.bxm.warcar.dpl2.dir.PluginChangedListener;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import com.bxm.warcar.dpl2.plugin.PluginLoader;
import com.bxm.warcar.utils.NamedThreadFactory;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginChangedListener
implements PluginChangedListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginChangedListener.class);
    private final PluginBus pluginBus;
    private final PluginLoader pluginLoader;
    private final Map<String, String> filePathAndKeyMapping = Maps.newHashMap();
    private final ExecutorService controlExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("DPL-Controller"));

    public DefaultPluginChangedListener(PluginBus pluginBus, PluginLoader pluginLoader) {
        this.pluginBus = pluginBus;
        this.pluginLoader = pluginLoader;
    }

    @Override
    public void onChanged(PluginChangedEvent event) {
        String pluginKey;
        List<String> added = event.getAdded();
        List<String> updated = event.getUpdated();
        List<String> removed = event.getRemoved();
        if (CollectionUtils.isNotEmpty(added)) {
            for (String f : added) {
                this.addPlugin(f);
            }
        }
        if (CollectionUtils.isNotEmpty(updated)) {
            for (String f : updated) {
                pluginKey = this.filePathAndKeyMapping.get(f);
                if (StringUtils.isBlank((String)pluginKey)) {
                    log.debug("Plugin file[{}] load has failed previously, add plugin directly.", (Object)f);
                    this.addPlugin(f);
                    continue;
                }
                this.updatePlugin(f, pluginKey);
            }
        }
        if (CollectionUtils.isNotEmpty(removed)) {
            for (String f : removed) {
                pluginKey = this.filePathAndKeyMapping.get(f);
                if (StringUtils.isBlank((String)pluginKey)) continue;
                this.removePlugin(pluginKey);
            }
        }
    }

    private void addPlugin(String filePath) {
        String pluginKey = this.installPlugin(filePath);
        if (StringUtils.isBlank((String)pluginKey)) {
            return;
        }
        this.filePathAndKeyMapping.put(filePath, pluginKey);
    }

    private String installPlugin(final String filePath) {
        Future<String> future = this.controlExecutor.submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    Plugin plugin = DefaultPluginChangedListener.this.createPlugin(filePath);
                    if (null == plugin) {
                        return null;
                    }
                    DefaultPluginChangedListener.this.pluginBus.register(plugin);
                    return plugin.getConfig().getKey();
                }
                catch (PluginRuntimeException e) {
                    log.error("installPlugin: " + filePath, (Throwable)e);
                    return null;
                }
            }
        });
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            future.cancel(true);
            throw new RuntimeException("installPlugin: ", e);
        }
        catch (ExecutionException e) {
            future.cancel(true);
            Throwable cause = e.getCause();
            throw this.launderThrowable("installPlugIn[" + filePath + "]:", cause);
        }
    }

    private Plugin createPlugin(String filePath) {
        return this.pluginLoader.load(new PluginConfig(filePath));
    }

    private void updatePlugin(String filePath, String pluginKey) {
        this.uninstallPlugin(pluginKey);
        this.installPlugin(filePath);
    }

    private void removePlugin(String pluginKey) {
        this.uninstallPlugin(pluginKey);
        this.filePathAndKeyMapping.remove(pluginKey);
    }

    private void uninstallPlugin(String pluginKey) {
        this.controlExecutor.execute(() -> {
            Plugin plugin = this.pluginBus.lookup(pluginKey);
            if (null == plugin) {
                log.error("Key[{}] is not mapping any plugin.", (Object)pluginKey);
                return;
            }
            this.pluginBus.unregister(plugin);
            plugin.destroy();
        });
    }

    private RuntimeException launderThrowable(String message, Throwable t) {
        if (t instanceof RuntimeException) {
            return new RuntimeException(message, t);
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(message, t);
    }
}

