/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.dir;

import com.bxm.warcar.dpl2.dir.PluginChangedEvent;
import com.bxm.warcar.dpl2.dir.PluginChangedListener;
import com.bxm.warcar.dpl2.dir.Snapshot;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public final class PluginDirMonitor
implements ApplicationListener<ApplicationReadyEvent>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PluginDirMonitor.class);
    private static final long DEFAULT_CHECK_TIMEOUT = 1000L;
    private final PluginChangedListener listener;
    private final String dir;
    private final long checkTimeout;
    private final ScheduledExecutorService scheduled = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("PluginDirMonitor"));
    private Snapshot lastSnapshot;

    public PluginDirMonitor(String dir) {
        this(new PluginChangedListener(){}, dir);
    }

    public PluginDirMonitor(PluginChangedListener listener, String dir) {
        this(listener, dir, 1000L);
    }

    public PluginDirMonitor(PluginChangedListener listener, String dir, long checkTimeout) {
        this.listener = listener;
        this.dir = dir;
        this.checkTimeout = checkTimeout;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.scheduled.scheduleWithFixedDelay(this::doCheckDir, 0L, this.checkTimeout, TimeUnit.MILLISECONDS);
    }

    public void destroy() throws Exception {
        this.scheduled.shutdownNow();
    }

    private void doCheckDir() {
        try {
            Snapshot newSnapshot = new Snapshot(this.dir);
            if (this.isModified(newSnapshot)) {
                if (log.isDebugEnabled()) {
                    log.debug("checkDir: {} is changed.", (Object)this.dir);
                }
                Snapshot oldSnapshot = this.lastSnapshot;
                this.lastSnapshot = newSnapshot;
                this.listener.onChanged(new PluginChangedEvent(this.dir, oldSnapshot, newSnapshot));
            }
        }
        catch (Exception e) {
            log.error("doCheckDir: ", (Throwable)e);
        }
    }

    private boolean isModified(Snapshot newSnapshot) {
        if (null == this.lastSnapshot) {
            return true;
        }
        if (this.lastSnapshot.hashCode() != newSnapshot.hashCode()) {
            return true;
        }
        return !this.lastSnapshot.equals(newSnapshot);
    }

    public String getDir() {
        return this.dir;
    }

    public long getCheckTimeout() {
        return this.checkTimeout;
    }
}

