/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.*;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author allen
 * @since 1.0.0
 */
public class PluginServiceImpl implements PluginService {

    private static final Logger LOGGER = LoggerFactory.getLogger(PluginServiceImpl.class);

    private final PluginManager pluginManager;
    private final PluginLoader pluginLoader;

    public PluginServiceImpl(PluginManager pluginManager, PluginLoader pluginLoader) {
        Preconditions.checkNotNull(pluginManager);
        Preconditions.checkNotNull(pluginLoader);
        this.pluginManager = pluginManager;
        this.pluginLoader = pluginLoader;
    }

    @Override
    public Plugin loadAndRegister(PluginConfig pluginConfig) {
        Preconditions.checkNotNull(pluginConfig);
        if (pluginConfig.isEnabled()) {
            Plugin plugin = pluginLoader.load(pluginConfig);
            Plugin oldPlugin = pluginManager.register(plugin);
            destroyQuietly(oldPlugin);
            return plugin;
        }

        removePlugin(pluginConfig.getName());
        return null;
    }

    private Plugin removePlugin(String pluginName) {
        Plugin removed = pluginManager.remove(pluginName);
        destroyQuietly(removed);
        return removed;
    }

    private static void destroyQuietly(Plugin plugin) {
        if (plugin != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Destroy plugin: {}", plugin.getName());
                }
                plugin.destroy();
            } catch (Exception e) {
                LOGGER.error("Failed to destroy plugin " + plugin, e);
            }
        }
    }
}
