/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.hotswap;

import com.bxm.warcar.dpl.PluginRuntimeException;
import com.bxm.warcar.dpl.hotswap.ClassFilter;
import com.bxm.warcar.dpl.hotswap.PlugInResourceHandler;
import com.bxm.warcar.dpl.hotswap.ResourceFilter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader2
extends ClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginClassLoader2.class);
    private static final String LIB_PREFIX = "lib/";
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private static final String MAIN_RESOURCE_PREFIX = "main";
    private static final String INNER_PREFIX_SEP = "!";
    private static final String MAIN_RESOURCE_PREFIX_SEP = "main!";
    private static final int MAIN_RESOURCE_PREFIX_SEP_LEN = "main!".length();
    private final List<String> subJarNameList = new ArrayList<String>();
    private final Map<String, ByteCode> byteCodeCache = new HashMap<String, ByteCode>();
    private ProtectionDomain defaultProtectionDomain = null;
    private final String plugInJarPath;

    public PluginClassLoader2(String jarPath) {
        this(jarPath, ClassLoader.getSystemClassLoader());
    }

    public PluginClassLoader2(String jarPath, ClassLoader classLoader) {
        super(classLoader);
        if (StringUtils.isBlank((String)jarPath)) {
            throw new IllegalArgumentException("jarPath is blank.");
        }
        this.plugInJarPath = jarPath;
        this.init(jarPath);
    }

    public String getPlugInJarPath() {
        return this.plugInJarPath;
    }

    private synchronized void init(String jarPath) {
        URL plugInURL = null;
        try {
            plugInURL = new URL("file:" + jarPath);
        }
        catch (MalformedURLException e) {
            throw new PluginRuntimeException("bad url path:", e);
        }
        this.defaultProtectionDomain = this.generateProtectionDomain(plugInURL);
        try {
            this.loadByteCodes(jarPath);
        }
        catch (IOException e) {
            throw new PluginRuntimeException("loadByteCodes:", e);
        }
        this.subJarNameList.add(MAIN_RESOURCE_PREFIX);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("plugin [" + jarPath + "] load byte code successful.");
        }
    }

    private ProtectionDomain generateProtectionDomain(URL url) {
        CodeSource source = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(source, null, this, null);
    }

    protected synchronized ProtectionDomain getProtectionDomain() {
        return this.defaultProtectionDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadByteCodes(String jarPath) throws IOException {
        if (null == jarPath) {
            throw new NullPointerException("plugin jar file path must not be null.");
        }
        JarFile pluginFile = null;
        try {
            pluginFile = new JarFile(jarPath);
            Manifest manifest = pluginFile.getManifest();
            Enumeration<JarEntry> e = pluginFile.entries();
            while (e.hasMoreElements()) {
                JarEntry je = e.nextElement();
                if (je.isDirectory()) continue;
                String entryName = je.getName();
                InputStream is = pluginFile.getInputStream(je);
                if (null == is) {
                    throw new IOException("Unable to load resource " + entryName);
                }
                if (this.isJar(entryName)) {
                    this.loadJarByteCodes(is, entryName);
                    continue;
                }
                this.loadSingleByteCodes(is, entryName, manifest, MAIN_RESOURCE_PREFIX);
            }
        }
        finally {
            if (null != pluginFile) {
                pluginFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarByteCodes(InputStream is, String jarName) throws IOException {
        if (null == is) {
            throw new NullPointerException();
        }
        this.subJarNameList.add(jarName);
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(is);
            Manifest manifest = jis.getManifest();
            JarEntry je = jis.getNextJarEntry();
            while (null != je) {
                if (!je.isDirectory()) {
                    String entryName = je.getName();
                    this.loadSingleByteCodes(jis, entryName, manifest, jarName);
                }
                je = jis.getNextJarEntry();
            }
        }
        finally {
            if (null != jis) {
                jis.close();
            }
        }
    }

    private void loadSingleByteCodes(InputStream is, String entryName, Manifest manifest, String type) throws IOException {
        byte[] data = this.getByteArray(is);
        if (this.isClass(entryName)) {
            String classBinaryName = this.resolveClassName(entryName);
            this.byteCodeCache.put(classBinaryName, new ByteCode(classBinaryName, entryName, data, manifest, null));
        }
        String resourceGlobalBinaryName = this.resolveResourceName(type, entryName);
        String resourceLocalBinaryName = entryName;
        this.byteCodeCache.put(resourceGlobalBinaryName, new ByteCode(resourceGlobalBinaryName, entryName, data, manifest, null));
        this.byteCodeCache.put(resourceLocalBinaryName, new ByteCode(resourceLocalBinaryName, entryName, data, manifest, null));
    }

    private boolean isJar(String entryName) {
        return entryName.startsWith(LIB_PREFIX) && entryName.endsWith(JAR_SUFFIX);
    }

    private boolean isClass(String originalName) {
        return originalName.endsWith(CLASS_SUFFIX);
    }

    private byte[] getByteArray(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.copy(is, baos);
        return baos.toByteArray();
    }

    private String resolveResourceName(String jarName, String resourceName) {
        return jarName + INNER_PREFIX_SEP + resourceName;
    }

    private String resolveClassName(String name) {
        return name.substring(0, name.length() - 6).replace('/', '.');
    }

    public List<String> searchResources(String resourcePath) {
        return this.searchResources(resourcePath, true);
    }

    public List<String> searchResources(String resourcePath, boolean isIncludeLib) {
        return this.searchResources(resourcePath, ResourceFilter.DEFAULT, isIncludeLib);
    }

    public List<String> searchResources(String resourcePath, ResourceFilter resourceFilter) {
        return this.searchResources(resourcePath, resourceFilter, true);
    }

    public List<String> searchResources(String resourcePath, ResourceFilter resourceFilter, boolean isIncludeLib) {
        if (StringUtils.isBlank((String)resourcePath)) {
            throw new IllegalArgumentException("resourcePath");
        }
        if (null == resourceFilter) {
            throw new NullPointerException("resourceFilter");
        }
        return this.doSearchResources(resourcePath.trim(), resourceFilter, isIncludeLib);
    }

    private List<String> doSearchResources(String resourcePath, ResourceFilter resourceFilter, boolean isIncludeLib) {
        HashSet ret = Sets.newHashSet();
        Pattern pattern = this.genResourceMatchPattern(resourcePath, isIncludeLib);
        for (Map.Entry<String, ByteCode> e : this.byteCodeCache.entrySet()) {
            String rp;
            Matcher m;
            if (e.getValue().isJavaClass() || !(m = pattern.matcher(rp = e.getKey())).matches()) continue;
            if (!isIncludeLib) {
                rp = rp.substring(MAIN_RESOURCE_PREFIX_SEP_LEN);
            } else if (rp.startsWith(MAIN_RESOURCE_PREFIX_SEP)) {
                rp.substring(MAIN_RESOURCE_PREFIX_SEP_LEN);
            }
            if (!resourceFilter.accept(rp)) continue;
            ret.add(rp);
        }
        return Lists.newArrayList((Iterable)ret);
    }

    private Pattern genResourceMatchPattern(String source, boolean isIncludeLib) {
        String regex = "";
        if (!"/".equals(source) && !"/*".equals(source)) {
            if (source.endsWith("/*")) {
                source = source.substring(0, source.length() - 1);
                regex = source + "([a-zA-Z]{1}[a-zA-Z0-9]*/)*([a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]*){1}";
            } else {
                regex = source.endsWith("/") ? source + "([a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]+){1}" : source + "(/[a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]+){1}";
            }
        }
        regex = !isIncludeLib ? MAIN_RESOURCE_PREFIX_SEP + regex : "(?!main\\!)" + regex;
        return Pattern.compile(regex);
    }

    public List<Class<?>> searchClasses(String pkgPath, ClassFilter classFilter) {
        if (StringUtils.isBlank((String)pkgPath)) {
            throw new IllegalArgumentException("pkgName");
        }
        if (null == classFilter) {
            throw new NullPointerException("classFilter");
        }
        pkgPath = pkgPath.trim();
        ArrayList ret = Lists.newArrayList();
        Pattern pattern = this.genClassMatchPattern(pkgPath);
        for (Map.Entry<String, ByteCode> e : this.byteCodeCache.entrySet()) {
            String cp;
            Matcher m;
            if (!e.getValue().isJavaClass() || !(m = pattern.matcher(cp = e.getKey())).matches()) continue;
            try {
                Class<?> clazz = this.loadClass(cp);
                if (null == clazz || !classFilter.accept(clazz)) continue;
                ret.add(clazz);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException("can not load class[" + e.getKey() + "];cause:" + e);
            }
        }
        return ret;
    }

    public List<Class<?>> searchClasses(String pkgPath) {
        return this.searchClasses(pkgPath, ClassFilter.DEFAULT);
    }

    private Pattern genClassMatchPattern(String source) {
        if (".".equals(source)) {
            return Pattern.compile("([A-Z]{1}[a-zA-Z0-9]*){1}");
        }
        if (".*".equals(source)) {
            return Pattern.compile("([a-zA-Z]{1}[a-zA-Z0-9]*\\.)*([A-Z]{1}[a-zA-Z0-9]*){1}");
        }
        if (source.endsWith(".*")) {
            source = source.substring(0, source.length() - 2);
            source = source.replaceAll("\\.", "\\\\.");
            return Pattern.compile(source + "(\\.[a-zA-Z]{1}[a-zA-Z0-9]*)*(\\.[A-Z]{1}[a-zA-Z0-9]*){1}");
        }
        source = source.replaceAll("\\.", "\\\\.");
        return Pattern.compile(source + "(\\.[A-Z]{1}[a-zA-Z0-9]*){1}");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (null != clazz) {
            return clazz;
        }
        ByteCode bc = this.byteCodeCache.get(name);
        if (null != bc) {
            return this.defineClass(bc);
        }
        throw new ClassNotFoundException(name);
    }

    protected InputStream getByteStream(String resource) {
        InputStream result = null;
        ClassLoader parent = this.getParent();
        if (parent != null && null != (result = parent.getResourceAsStream(resource))) {
            return result;
        }
        ByteCode byteCode = this.byteCodeCache.get(resource);
        if (null == byteCode) {
            return null;
        }
        return new ByteArrayInputStream(byteCode.bytes);
    }

    @Override
    protected URL findResource(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank.");
        }
        name = this.resolveQueryResouceName(name);
        URL url = this.getParent().getResource(name);
        if (null != url) {
            return url;
        }
        try {
            return new URL(null, PlugInResourceHandler.getProtocol() + name, new PlugInResourceHandler(this));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("unable to locate " + name + " cause:", e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        if (StringUtils.isBlank((String)name)) {
            throw new IllegalArgumentException("name is blank.");
        }
        name = this.resolveQueryResouceName(name);
        final ArrayList<URL> urlList = new ArrayList<URL>();
        for (String jarName : this.subJarNameList) {
            String resourceGlobalBinaryName = this.resolveResourceName(jarName, name);
            ByteCode byteCode = this.byteCodeCache.get(resourceGlobalBinaryName);
            if (null == byteCode) continue;
            urlList.add(new URL(null, PlugInResourceHandler.getProtocol() + resourceGlobalBinaryName, new PlugInResourceHandler(this)));
        }
        if (0 == urlList.size()) {
            return super.findResources(name);
        }
        return new Enumeration<URL>(){
            private int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < urlList.size();
            }

            @Override
            public URL nextElement() {
                return (URL)urlList.get(this.idx++);
            }
        };
    }

    private String resolveQueryResouceName(String name) {
        if ((name = name.replaceAll("\\\\", "/")).startsWith("/")) {
            name = name.substring(1);
        }
        String[] items = name.split("/");
        ArrayList<String> filteRet = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (item.equals(".")) continue;
            if (item.equals("..")) {
                ++i;
            }
            filteRet.add(item);
        }
        StringBuilder retSb = new StringBuilder(64);
        for (String item : filteRet) {
            retSb.append(item).append("/");
        }
        return retSb.substring(0, retSb.length() - 1);
    }

    private Class<?> defineClass(ByteCode bytecode) throws ClassFormatError {
        String name = bytecode.binaryName;
        int i = name.lastIndexOf(46);
        if (i != -1) {
            String pkgname = name.substring(0, i);
            Package pkg = this.getPackage(pkgname);
            Manifest man = bytecode.manifest;
            if (pkg == null) {
                if (man != null) {
                    this.definePackage(pkgname, man, this.defaultProtectionDomain.getCodeSource().getLocation());
                } else {
                    this.definePackage(pkgname, null, null, null, null, null, null, this.defaultProtectionDomain.getCodeSource().getLocation());
                }
            }
        }
        return this.defineClass(bytecode.getBinaryName(), bytecode.getBytes(), this.defaultProtectionDomain);
    }

    protected Class<?> defineClass(String name, byte[] bytes, ProtectionDomain pd) throws ClassFormatError {
        return this.defineClass(name, bytes, 0, bytes.length, pd);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        boolean isSealed;
        String path = name.concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealed != null && (isSealed = Boolean.parseBoolean(sealed))) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private void unloadNativeLibs() throws Throwable {
        Field field = PluginClassLoader2.class.getSuperclass().getDeclaredField("nativeLibraries");
        field.setAccessible(true);
        Vector libs = (Vector)field.get(this);
        for (Object o : libs) {
            Method finalize = o.getClass().getDeclaredMethod("finalize", new Class[0]);
            finalize.setAccessible(true);
            finalize.invoke(o, new Object[0]);
        }
    }

    public void freeLibrary() {
        try {
            this.unloadNativeLibs();
        }
        catch (Throwable e) {
            throw new RuntimeException("unloadNativeLibs:", e);
        }
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        IOUtils.copy((InputStream)in, (OutputStream)out);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE).append("plugInJarPath", (Object)this.plugInJarPath).append("itemCount", this.byteCodeCache.size()).append("libJars", this.subJarNameList).toString();
    }

    private static final class ByteCode {
        private final String binaryName;
        private final String originalName;
        private final byte[] bytes;
        private final Manifest manifest;
        private String codebase;
        private static final byte[] MAGIC_NUMBER = new byte[]{-54, -2, -70, -66};

        public ByteCode(String binaryName, String originalName, byte[] bytes, Manifest manifest, String codebase) {
            this.binaryName = binaryName;
            this.originalName = originalName;
            this.bytes = bytes;
            this.manifest = manifest;
            this.codebase = codebase;
        }

        public String getBinaryName() {
            return this.binaryName;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public String getCodebase() {
            return this.codebase;
        }

        public void setCodebase(String codebase) {
            this.codebase = codebase;
        }

        public boolean isJavaClass() {
            if (this.bytes.length <= 4) {
                return false;
            }
            return this.bytes[0] == MAGIC_NUMBER[0] && this.bytes[1] == MAGIC_NUMBER[1] && this.bytes[2] == MAGIC_NUMBER[2] && this.bytes[3] == MAGIC_NUMBER[3];
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.DEFAULT_STYLE);
        }
    }
}

