/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.hotswap;

import com.bxm.warcar.dpl2.PluginRuntimeException;
import com.bxm.warcar.dpl2.hotswap.ClassFilter;
import com.bxm.warcar.dpl2.hotswap.PluginResourceURLStreamHandler;
import com.bxm.warcar.dpl2.hotswap.ResourceFileter;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginClassLoader
extends ClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginClassLoader.class);
    private static final String LIB_PREFIX = "lib/";
    private static final String JAR_SUFFIX = ".jar";
    private static final String CLASS_SUFFIX = ".class";
    private static final String MAIN_RESOURCE_PREFIX = "main";
    private static final String INNER_PREFIX_SEP = "!";
    private static final String MAIN_RESOURCE_PREFIX_SEP = "main!";
    private static final int MAIN_RESOURCE_PREFIX_SEP_LEN = "main!".length();
    private final List<String> subJarNameList = Lists.newArrayList();
    private final Map<String, ByteCode> byteCodeCache = Maps.newHashMap();
    private final String pluginJarPath;
    private ProtectionDomain protectionDomain;
    private static final Pattern CLASS_DOT = Pattern.compile("([A-Z]{1}[a-zA-Z0-9]*){1}");
    private static final Pattern CLASS_DOT_STAR = Pattern.compile("([a-zA-Z]{1}[a-zA-Z0-9]*\\.)*([A-Z]{1}[a-zA-Z0-9]*){1}");

    public PluginClassLoader(String pluginJarPath) {
        this(pluginJarPath, ClassLoader.getSystemClassLoader());
    }

    public PluginClassLoader(String pluginJarPath, ClassLoader classLoader) {
        super(classLoader);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)pluginJarPath));
        this.pluginJarPath = pluginJarPath;
        this.init(pluginJarPath);
    }

    private synchronized void init(String jar) {
        URL url;
        try {
            url = new URL("file:" + jar);
        }
        catch (MalformedURLException e) {
            throw new PluginRuntimeException("bad url!", e);
        }
        this.protectionDomain = this.generate(url);
        try {
            this.loadByteCodes(jar);
        }
        catch (IOException e) {
            throw new PluginRuntimeException("loadByteCodes: ", e);
        }
        this.subJarNameList.add(MAIN_RESOURCE_PREFIX);
        if (log.isDebugEnabled()) {
            log.debug("Plugin [{}] load byte code successful.", (Object)jar);
        }
    }

    private ProtectionDomain generate(URL url) {
        CodeSource codeSource = new CodeSource(url, (Certificate[])null);
        return new ProtectionDomain(codeSource, null, this, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadByteCodes(String jarFilePath) throws IOException {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFilePath);
            Manifest manifest = jar.getManifest();
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry jarEntry = e.nextElement();
                if (jarEntry.isDirectory()) continue;
                String entryName = jarEntry.getName();
                InputStream inputStream = jar.getInputStream(jarEntry);
                if (null == inputStream) {
                    throw new IOException("Unable to load resource: " + entryName);
                }
                if (this.isJar(entryName)) {
                    this.loadJarByteCodes(inputStream, entryName);
                    continue;
                }
                this.loadSingleByteCodes(inputStream, entryName, manifest, MAIN_RESOURCE_PREFIX);
            }
        }
        finally {
            if (null != jar) {
                jar.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarByteCodes(InputStream is, String jarName) throws IOException {
        this.subJarNameList.add(jarName);
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(is);
            Manifest manifest = jis.getManifest();
            JarEntry e = jis.getNextJarEntry();
            while (null != e) {
                if (!e.isDirectory()) {
                    String entryName = e.getName();
                    this.loadSingleByteCodes(jis, entryName, manifest, jarName);
                }
                e = jis.getNextJarEntry();
            }
        }
        finally {
            if (null != jis) {
                jis.close();
            }
        }
    }

    private void loadSingleByteCodes(InputStream is, String entryName, Manifest manifest, String jarName) throws IOException {
        byte[] bytes = this.getBytes(is);
        if (this.isClass(entryName)) {
            String classBinaryName = this.resolveClassName(entryName);
            this.byteCodeCache.put(classBinaryName, new ByteCode(classBinaryName, entryName, bytes, manifest));
        }
        String resourceGlobalBinaryName = this.resolveResourceName(jarName, entryName);
        this.byteCodeCache.put(resourceGlobalBinaryName, new ByteCode(resourceGlobalBinaryName, entryName, bytes, manifest));
        this.byteCodeCache.put(entryName, new ByteCode(entryName, entryName, bytes, manifest));
    }

    private byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        return baos.toByteArray();
    }

    private boolean isJar(String name) {
        return name.startsWith(LIB_PREFIX) && name.endsWith(JAR_SUFFIX);
    }

    private boolean isClass(String name) {
        return name.endsWith(CLASS_SUFFIX);
    }

    private String resolveClassName(String name) {
        return name.substring(0, name.length() - 6).replace('/', '.');
    }

    private String resolveResourceName(String jarName, String resourceName) {
        return jarName + INNER_PREFIX_SEP + resourceName;
    }

    public List<String> searchResources(String resourcePath) {
        return this.searchResources(resourcePath, true);
    }

    public List<String> searchResources(String resourcePath, boolean isIncludeLib) {
        return this.searchResources(resourcePath, new ResourceFileter(){}, isIncludeLib);
    }

    public List<String> searchResources(String resourcePath, ResourceFileter resourceFileter) {
        return this.searchResources(resourcePath, resourceFileter, true);
    }

    public List<String> searchResources(String resourcePath, ResourceFileter resourceFileter, boolean isIncludeLib) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)resourcePath));
        Preconditions.checkNotNull((Object)resourceFileter);
        return this.doSearchResources(resourcePath, resourceFileter, isIncludeLib);
    }

    private List<String> doSearchResources(String resourcePath, ResourceFileter resourceFileter, boolean isIncludeLib) {
        HashSet set = Sets.newHashSet();
        Pattern pattern = this.generateResourceMatchPattern(resourcePath, isIncludeLib);
        for (Map.Entry<String, ByteCode> entry : this.byteCodeCache.entrySet()) {
            String key;
            Matcher matcher;
            if (entry.getValue().isJavaClass() || !(matcher = pattern.matcher(key = entry.getKey())).matches()) continue;
            if (!isIncludeLib) {
                key = key.substring(MAIN_RESOURCE_PREFIX_SEP_LEN);
            } else if (key.startsWith(MAIN_RESOURCE_PREFIX)) {
                key = key.substring(MAIN_RESOURCE_PREFIX_SEP_LEN);
            }
            if (!resourceFileter.accept(key)) continue;
            set.add(key);
        }
        return Lists.newArrayList((Iterable)set);
    }

    private Pattern generateResourceMatchPattern(String source, boolean isIncludeLib) {
        String regex = "";
        if (!"/".equals(source) && !"/*".equals(source)) {
            if (source.endsWith("/*")) {
                source = source.substring(0, source.length() - 1);
                regex = source + "([a-zA-Z]{1}[a-zA-Z0-9]*/)*([a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]*){1}";
            } else {
                regex = source.endsWith("/") ? source + "([a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]+){1}" : source + "(/[a-zA-Z\\-\\_\\!]{1}[a-zA-Z0-9\\.\\-\\_\\!]+){1}";
            }
        }
        regex = !isIncludeLib ? MAIN_RESOURCE_PREFIX_SEP + regex : "(?!main\\!)" + regex;
        return Pattern.compile(regex);
    }

    @Override
    protected URL findResource(String name) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        name = this.resolveQueryResourceName(name);
        URL url = this.getParent().getResource(name);
        if (null != url) {
            return url;
        }
        try {
            return new URL(null, PluginResourceURLStreamHandler.getProtocol() + name, new PluginResourceURLStreamHandler(this));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable to locate " + name, e);
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)name));
        name = this.resolveQueryResourceName(name);
        final ArrayList urls = Lists.newArrayList();
        for (String jarName : this.subJarNameList) {
            String resourceGlobalBinaryName = this.resolveResourceName(jarName, name);
            ByteCode byteCode = this.byteCodeCache.get(resourceGlobalBinaryName);
            if (null == byteCode) continue;
            urls.add(new URL(null, PluginResourceURLStreamHandler.getProtocol() + resourceGlobalBinaryName, new PluginResourceURLStreamHandler(this)));
        }
        if (CollectionUtils.isEmpty((Collection)urls)) {
            return super.findResources(name);
        }
        return new Enumeration<URL>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < urls.size();
            }

            @Override
            public URL nextElement() {
                return (URL)urls.get(this.index++);
            }
        };
    }

    private String resolveQueryResourceName(String name) {
        if ((name = name.replaceAll("\\\\", "/")).startsWith("/")) {
            name = name.substring(1);
        }
        String[] items = name.split("/");
        ArrayList<String> filteRet = new ArrayList<String>();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            if (".".equals(item)) continue;
            if ("..".equals(item)) {
                ++i;
            }
            filteRet.add(item);
        }
        StringBuilder retSb = new StringBuilder(64);
        for (String item : filteRet) {
            retSb.append(item).append("/");
        }
        return retSb.substring(0, retSb.length() - 1);
    }

    public List<Class<?>> searchClasses(String pkgPath) {
        return this.searchClasses(pkgPath, new ClassFilter(){});
    }

    public List<Class<?>> searchClasses(String pkgPath, ClassFilter classFilter) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)pkgPath));
        Preconditions.checkNotNull((Object)classFilter);
        pkgPath = pkgPath.trim();
        ArrayList result = Lists.newArrayList();
        Pattern pattern = this.generateClassMatchPattern(pkgPath);
        for (Map.Entry<String, ByteCode> entry : this.byteCodeCache.entrySet()) {
            String key;
            Matcher matcher;
            if (!entry.getValue().isJavaClass() || !(matcher = pattern.matcher(key = entry.getKey())).matches()) continue;
            try {
                Class<?> clazz = this.loadClass(key);
                if (null == clazz || !classFilter.accept(clazz)) continue;
                result.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Cannot load class: " + key, e);
            }
        }
        return result;
    }

    private Pattern generateClassMatchPattern(String source) {
        if (".".equals(source)) {
            return CLASS_DOT;
        }
        if (".*".equals(source)) {
            return CLASS_DOT_STAR;
        }
        if (source.endsWith(".*")) {
            source = source.substring(0, source.length() - 2);
            source = source.replaceAll("\\.", "\\\\.");
            return Pattern.compile(source + "(\\.[a-zA-Z]{1}[a-zA-Z0-9]*)*(\\.[A-Z]{1}[a-zA-Z0-9]*){1}");
        }
        source = source.replaceAll("\\.", "\\\\.");
        return Pattern.compile(source + "(\\.[A-Z]{1}[a-zA-Z0-9]*){1}");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = super.findLoadedClass(name);
        if (null != clazz) {
            return clazz;
        }
        ByteCode byteCode = this.byteCodeCache.get(name);
        if (null == byteCode) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(byteCode);
    }

    private Class<?> defineClass(ByteCode byteCode) {
        String name = byteCode.getBinaryName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String pkgName = name.substring(0, index);
            Package pkg = super.getPackage(pkgName);
            Manifest manifest = byteCode.getManifest();
            if (null == pkg) {
                if (null != manifest) {
                    this.definePackage(pkgName, manifest, this.protectionDomain.getCodeSource().getLocation());
                } else {
                    super.definePackage(pkgName, null, null, null, null, null, null, this.protectionDomain.getCodeSource().getLocation());
                }
            }
        }
        return this.defineClass(byteCode.getBinaryName(), byteCode.getBytes(), this.protectionDomain);
    }

    private Class<?> defineClass(String name, byte[] bytes, ProtectionDomain protectionDomain) {
        return super.defineClass(name, bytes, 0, bytes.length, protectionDomain);
    }

    private Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        boolean isSealed;
        String path = name.concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if (sealed != null && (isSealed = Boolean.parseBoolean(sealed))) {
            sealBase = url;
        }
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    InputStream getByteInputStream(String resource) {
        InputStream is;
        ClassLoader parent = this.getParent();
        if (null != parent && null != (is = parent.getResourceAsStream(resource))) {
            return is;
        }
        ByteCode byteCode = this.byteCodeCache.get(resource);
        return null == byteCode ? null : new ByteArrayInputStream(byteCode.getBytes());
    }

    public String getPluginJarPath() {
        return this.pluginJarPath;
    }

    public synchronized ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    private static final class ByteCode {
        private static final byte[] CLASS_HEADER_MIGIC_NUMBER = new byte[]{-54, -2, -70, -66};
        private final String binaryName;
        private final String originalName;
        private final byte[] bytes;
        private final Manifest manifest;

        public ByteCode(String binaryName, String originalName, byte[] bytes, Manifest manifest) {
            this.binaryName = binaryName;
            this.originalName = originalName;
            this.bytes = bytes;
            this.manifest = manifest;
        }

        public boolean isJavaClass() {
            return this.bytes.length > 4 && this.bytes[0] == CLASS_HEADER_MIGIC_NUMBER[0] && this.bytes[1] == CLASS_HEADER_MIGIC_NUMBER[1] && this.bytes[2] == CLASS_HEADER_MIGIC_NUMBER[2] && this.bytes[3] == CLASS_HEADER_MIGIC_NUMBER[3];
        }

        public String getBinaryName() {
            return this.binaryName;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public Manifest getManifest() {
            return this.manifest;
        }

        public String toString() {
            return "ByteCode{binaryName='" + this.binaryName + '\'' + ", originalName='" + this.originalName + '\'' + ", bytes=" + Arrays.toString(this.bytes) + ", manifest=" + this.manifest + '}';
        }
    }
}

