/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl2.dir;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Snapshot {
    private static final Logger log = LoggerFactory.getLogger(Snapshot.class);
    private static final String DEFAULT_INCLUDE_SUFFIX = ".jar";
    private final Map<String, Long> files = new HashMap<String, Long>();

    public Snapshot(String dirName) {
        File dir = new File(dirName);
        if (dir.isDirectory()) {
            Object[] includes = dir.listFiles((dir1, name) -> this.isPlugInFile(name));
            if (ArrayUtils.isEmpty((Object[])includes)) {
                return;
            }
            for (Object file : includes) {
                this.files.put(((File)file).getAbsolutePath(), ((File)file).lastModified());
            }
        } else {
            log.error("Dir Snapshot: [" + dirName + "] is !NOT! directory.");
            throw new RuntimeException("[" + dirName + "] is !NOT! directory.");
        }
    }

    public Map<String, Long> getFiles() {
        return this.files;
    }

    private boolean isPlugInFile(String fileName) {
        return fileName.endsWith(DEFAULT_INCLUDE_SUFFIX);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return !(this.files == null ? other.files != null : !this.files.equals(other.files));
    }

    public String toString() {
        return "Snapshot(files=" + this.getFiles() + ")";
    }
}

