/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.dpl.impl;

import com.bxm.warcar.dpl.Plugin;
import com.bxm.warcar.dpl.PluginConfig;
import com.bxm.warcar.dpl.PluginLoader;
import com.bxm.warcar.dpl.PluginManager;
import com.bxm.warcar.dpl.PluginService;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginServiceImpl
implements PluginService {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginServiceImpl.class);
    private final PluginManager pluginManager;
    private final PluginLoader pluginLoader;

    public PluginServiceImpl(PluginManager pluginManager, PluginLoader pluginLoader) {
        Preconditions.checkNotNull((Object)pluginManager);
        Preconditions.checkNotNull((Object)pluginLoader);
        this.pluginManager = pluginManager;
        this.pluginLoader = pluginLoader;
    }

    @Override
    public Plugin loadAndRegister(PluginConfig pluginConfig) {
        Preconditions.checkNotNull((Object)pluginConfig);
        if (pluginConfig.isEnabled()) {
            Plugin plugin = this.pluginLoader.load(pluginConfig);
            Plugin oldPlugin = this.pluginManager.register(plugin);
            PluginServiceImpl.destroyQuietly(oldPlugin);
            return plugin;
        }
        this.removePlugin(pluginConfig.getName());
        return null;
    }

    private Plugin removePlugin(String pluginName) {
        Plugin removed = this.pluginManager.remove(pluginName);
        PluginServiceImpl.destroyQuietly(removed);
        return removed;
    }

    private static void destroyQuietly(Plugin plugin) {
        if (plugin != null) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Destroy plugin: {}", (Object)plugin.getName());
                }
                plugin.destroy();
            }
            catch (Exception e) {
                LOGGER.error("Failed to destroy plugin " + plugin, (Throwable)e);
            }
        }
    }
}

