/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.dpl.hotswap;

import java.io.IOException;
import java.io.InputStream;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class PlugInResourceHandler extends URLStreamHandler {

	private static final String DEFAULT_PROTOCOL = "pluginresource:";
	private static final String DEFAULT_CONTENT_TYPE = "text/plain";

	private PluginClassLoader2 plugInClassLoader;

	public PlugInResourceHandler(PluginClassLoader2 plugInClassLoader) {
		super();
		this.plugInClassLoader = plugInClassLoader;
	}

	@Override
	protected URLConnection openConnection(URL url) throws IOException {
		String p = url.getProtocol();
		if (!isValid(p))
			throw new RuntimeException("invalid protocol,expect " + getProtocol() + ",but " + p);

		final String resource = url.getPath();
		return new URLConnection(url) {
			public void connect() {
			}

			public String getContentType() {
				FileNameMap fileNameMap = URLConnection.getFileNameMap();
				String contentType = fileNameMap.getContentTypeFor(resource);
				if (contentType == null)
					contentType = DEFAULT_CONTENT_TYPE;
				return contentType;
			}

			public InputStream getInputStream() throws IOException {
				InputStream is = plugInClassLoader.getByteStream(resource);

				if (is == null)
					throw new IOException("plugInClassLoader.getByteStream() returned null for "
							+ resource);

				return is;
			}
		};
	}

	protected static String getProtocol() {
		return DEFAULT_PROTOCOL;
	}

	private boolean isValid(String p) {
		return p.equals(getProtocol().substring(0, getProtocol().length() - 1));
	}

}
