/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.file.upload.amazon;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.bxm.warcar.file.upload.FileException;
import com.bxm.warcar.file.upload.HttpFile;
import com.bxm.warcar.file.upload.HttpFileRequest;
import com.bxm.warcar.file.upload.HttpFileTransverter;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.UUIDHelper;
import org.apache.commons.lang3.StringUtils;

public class AmazonHttpFileManager
extends HttpFileTransverter {
    private String accessKey;
    private String secretKey;
    private String host;
    private String bucketName;
    private String serviceName;
    private long limitSize;
    private String amazonRegion;

    public AmazonHttpFileManager(String accessKey, String secretKey, String host, String bucketName, String serviceName, long limitSize, String amazonRegion) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.host = host;
        this.bucketName = bucketName;
        this.serviceName = serviceName;
        this.limitSize = limitSize;
        this.amazonRegion = amazonRegion;
    }

    @Override
    public String upload(HttpFileRequest request) throws Exception {
        HttpFile httpFile = this.analysis(request);
        return this.upload(httpFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload(HttpFile httpFile) throws FileException {
        if (httpFile == null) {
            throw new FileException("httpFile is null");
        }
        if (httpFile.getFileSize() > this.limitSize) {
            throw new FileException("The file is too large ,size is " + httpFile.getFileSize());
        }
        if (StringUtils.isBlank((CharSequence)this.bucketName)) {
            throw new FileException("bucketName is null");
        }
        String fileName = this.fileName(httpFile.getFileType());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        Regions region = Regions.fromName((String)this.amazonRegion);
        AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials))).build();
        PutObjectRequest request = this.buildPutObjectRequest(fileName, httpFile);
        try {
            s3Client.putObject(request);
        }
        finally {
            s3Client.shutdown();
        }
        return StringUtils.join((Object[])new String[]{this.getHost(), fileName});
    }

    private PutObjectRequest buildPutObjectRequest(String fileName, HttpFile httpFile) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain image/jpeg image/png");
        metadata.addUserMetadata("title", "someTitle");
        return new PutObjectRequest(this.bucketName, fileName, httpFile.getInputStream(), metadata);
    }

    private String fileName(String fileType) {
        return StringUtils.join((Object[])new String[]{DateHelper.format((String)"yyyy/MM/dd"), "/", this.serviceName, "/", UUIDHelper.generate(), fileType});
    }

    private String getHost() {
        if (StringUtils.isNotBlank((CharSequence)this.host)) {
            return this.host;
        }
        return "https://" + this.bucketName + ".s3.amazonaws.com/";
    }
}

