/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.file.upload;

import com.bxm.warcar.file.upload.FileException;
import com.bxm.warcar.file.upload.HttpFile;
import com.bxm.warcar.file.upload.HttpFileManager;
import com.bxm.warcar.file.upload.HttpFileRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public abstract class HttpFileTransverter
implements HttpFileManager {
    protected HttpFile analysis(HttpFileRequest request) throws IOException {
        if (request == null) {
            throw new FileException("HttpFileRequest is null ");
        }
        if (request.getRequest() != null) {
            HttpFile file = this.requestAnalysis(request);
            file.setBucketName(request.getBucketName());
            return file;
        }
        if (request.getMultipartFile() != null) {
            HttpFile file = this.multipartFileAnalysis(request.getMultipartFile(), request.getFileName());
            file.setBucketName(request.getBucketName());
            return file;
        }
        HttpFile file = this.fileAnalysis(request.getFile());
        file.setBucketName(request.getBucketName());
        return file;
    }

    private HttpFile requestAnalysis(HttpFileRequest request1) throws IOException {
        HttpServletRequest request = request1.getRequest();
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        if (!multipartResolver.isMultipart(request)) {
            throw new FileException(" is not  Multipart request");
        }
        MultipartRequest multiRequest = (MultipartRequest)request;
        MultipartFile file = multiRequest.getFile((String)multiRequest.getFileNames().next());
        return this.multipartFileAnalysis(file, request1.getFileName());
    }

    private HttpFile multipartFileAnalysis(MultipartFile file, String fixFileName) throws IOException {
        HttpFile httpFile = new HttpFile();
        String fileName = file.getOriginalFilename();
        String suffixNmae = fileName.substring(fileName.lastIndexOf("."));
        httpFile.setFileType(suffixNmae);
        httpFile.setInputStream(file.getInputStream());
        httpFile.setFileSize(file.getSize());
        httpFile.setFileName(fixFileName);
        return httpFile;
    }

    private HttpFile fileAnalysis(File file) throws FileNotFoundException {
        HttpFile httpFile = new HttpFile();
        String fileName = file.getName();
        String suffixNmae = fileName.substring(fileName.lastIndexOf("."));
        httpFile.setFileType(suffixNmae);
        httpFile.setInputStream(new FileInputStream(file));
        httpFile.setFileSize(file.length());
        return httpFile;
    }
}

