/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.file.upload.alioss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.bxm.warcar.file.upload.FileException;
import com.bxm.warcar.file.upload.HttpFile;
import com.bxm.warcar.file.upload.HttpFileRequest;
import com.bxm.warcar.file.upload.HttpFileTransverter;
import com.bxm.warcar.utils.DateHelper;
import com.bxm.warcar.utils.UUIDHelper;
import org.apache.commons.lang3.StringUtils;

public class AliOssHttpFileManager
extends HttpFileTransverter {
    private String endPoint;
    private String accessKeyId;
    private String accessKeySecret;
    private String host;
    private String bucketName = "bxm-image";
    private String serviceName = "default";
    private long limitSize = 0x400000L;

    public AliOssHttpFileManager(String endPoint, String accessKeyId, String accessKeySecret, String host, String bucketName, String serviceName, long limitSize) {
        this.endPoint = endPoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.host = host;
        this.bucketName = bucketName;
        this.serviceName = serviceName;
        this.limitSize = limitSize;
    }

    @Override
    public String upload(HttpFileRequest request) throws Exception {
        HttpFile httpFile = this.analysis(request);
        return this.upload(httpFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String upload(HttpFile httpFile) throws FileException {
        if (httpFile == null) {
            throw new FileException("httpFile is null");
        }
        if (httpFile.getFileSize() > this.limitSize) {
            throw new FileException("The file is too large ,size is " + httpFile.getFileSize());
        }
        if (StringUtils.isBlank((CharSequence)this.host)) {
            throw new FileException("host is null");
        }
        String fileName = this.fileName(httpFile);
        OSSClient ossClient = null;
        try {
            ossClient = this.bulidOSSClient();
            ossClient.putObject(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.bucketName}) ? this.bucketName : this.bucketName, fileName, httpFile.getInputStream());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
        return StringUtils.join((Object[])new String[]{this.host, fileName});
    }

    private String fileName(HttpFile httpFile) {
        String fileName = httpFile.getFileName();
        String fileType = httpFile.getFileType();
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = DateHelper.format((String)"yyyy/MM/dd") + "/" + this.serviceName + "/" + UUIDHelper.generate();
        }
        return StringUtils.join((Object[])new String[]{fileName, fileType});
    }

    private OSSClient bulidOSSClient() {
        return new OSSClient(this.endPoint, (CredentialsProvider)new DefaultCredentialProvider(this.accessKeyId, this.accessKeySecret), null);
    }
}

