package com.bxm.warcar.integration.distributed.zk;

import org.apache.commons.lang.StringUtils;
import org.springframework.aop.support.AopUtils;

import java.lang.reflect.Method;

/**
 * @author allen
 * @since 1.0.0
 */
public final class ZooKeeperDistributedPathUtils {

    private ZooKeeperDistributedPathUtils() {
    }

    public static String createPath(Object bean, Method method) {
        String beanName = AopUtils.getTargetClass(bean).getName();
        return StringUtils.join(new String[] {
                "/warcar",
                "distributed_locks",
                beanName,
                method.getName()
        }, "/");
    }
}
