package com.bxm.warcar.integration.dc.dot.impl;

import com.bxm.warcar.integration.dc.dot.Dot;
import com.bxm.warcar.integration.dc.dot.DotConstants;
import com.bxm.warcar.integration.dc.dot.DotParameter;
import com.google.common.base.Preconditions;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 默认的打点实现。
 *
 * @author allen
 * @date 2019/3/7
 * @since 1.0.0
 */
public class DefaultDotImpl implements Dot {

    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDotImpl.class);
    private final String dotUrl;
    private final RestTemplate rest;

    public DefaultDotImpl() {
        this(DotConstants.DEFAULT_DOT_URL);
    }

    public DefaultDotImpl(String dotUrl) {
        Preconditions.checkArgument(StringUtils.isNotBlank(dotUrl));
        this.dotUrl = dotUrl;
        this.rest = new RestTemplateBuilder()
                .setConnectTimeout(1000)
                .setReadTimeout(1000)
                .build();
    }

    @Override
    public String doGet(DotParameter parameter) {
        return doGet(parameter, String.class);
    }

    @Override
    public <T> T doGet(DotParameter parameter, Class<T> responseType) {
        return this.doGet0(parameter, responseType);
    }

    @Override
    public String doGet(Map<String, Object> parameter) {
        return doGet(parameter, String.class);
    }

    @Override
    public <T> T doGet(Map<String, Object> parameter, Class<T> responseType) {
        return this.doGet0(parameter, responseType);
    }

    private <T> T doGet0(Map<String, Object> parameter, Class<T> responseType) {
        String url = dotUrl;
        StringBuilder urlConnector = new StringBuilder(StringUtils.removeEnd(dotUrl, "?"));
        if (MapUtils.isNotEmpty(parameter)) {
            urlConnector.append("?");
            for (Map.Entry<String, Object> entry : parameter.entrySet()) {
                Object value = entry.getValue();
                if (null != value) {
                    urlConnector.append(entry.getKey()).append("={").append(entry.getKey()).append("}&");
                }
            }
            url = StringUtils.removeEnd(urlConnector.toString(), "&");
        }

        ResponseEntity<T> responseEntity = rest.getForEntity(url, responseType, parameter);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode != HttpStatus.OK) {
            LOGGER.warn("doGet0 code: {} for url: {}", statusCode, url);
        }
        return responseEntity.getBody();
    }

    @Override
    public String doPOST(Map<String, Object> parameter) {
        return doPOST(parameter, String.class);
    }

    @Override
    public <T> T doPOST(Map<String, Object> parameter, Class<T> responseType) {
        return this.doPOST0(parameter, responseType);
    }

    private <T> T doPOST0(Map<String, Object> parameter, Class<T> responseType) {
        String url = dotUrl;

        ResponseEntity<T> responseEntity = rest.postForEntity(url, parameter, responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();
        if (statusCode != HttpStatus.OK) {
            LOGGER.warn("doPOST0 code: {} for url: {}", statusCode, url);
        }
        return responseEntity.getBody();
    }
}
