package com.bxm.warcar.integration.eventbus.monitor;

import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @date 2019/4/26
 * @since 1.0.0
 */
public class AsyncEventParkMonitor extends LifeCycle {

    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncEventParkMonitor.class);
    private final ScheduledExecutorService consumeMonitor =
            new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("asyncEventPark-monitor"));
    private final AsyncEventPark asyncEventPark;
    private final int alarmQueueSize;
    private final MessageSender messageSender;

    public AsyncEventParkMonitor(AsyncEventPark asyncEventPark, int alarmQueueSize, MessageSender messageSender) {
        this.asyncEventPark = asyncEventPark;
        this.alarmQueueSize = alarmQueueSize;
        this.messageSender = messageSender;
    }

    @Override
    protected void doInit() {
        consumeMonitor.scheduleWithFixedDelay(() -> {
            int size = asyncEventPark.getQueueSize();
            if (size > 0) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("The AsyncEventPark thread pool queue size is {}", size);
                }
            }
            if (size >= alarmQueueSize) {
                if (null != messageSender) {
                    messageSender.send2(new Message("AsyncEventPark 当前队列堆积量：" + size + " 已达到报警线：" + alarmQueueSize));
                }
            }
        }, 1, 1, TimeUnit.MINUTES);
    }

    @Override
    protected void doDestroy() {
        consumeMonitor.shutdownNow();
    }
}
