package com.bxm.warcar.integration.message;

import com.bxm.warcar.integration.message.annotation.Messaging;
import com.bxm.warcar.mq.Producer;

/**
 * 消息生产者
 *
 * @author allen
 * @since 1.0.0
 * @see AsyncMessageProducer
 */
public interface MessageProducer {

    /**
     * 发送消息
     * @param topic TOPIC
     * @param arg 参数
     * @param returning 返回对象
     * @param messaging 消息声明注解
     */
    void send(String topic, Object arg, Object returning, Messaging messaging);

    Producer getProducer();

    Object getProperties();
}
