/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.taskcounter;

import com.bxm.warcar.integration.taskcounter.TaskCountStatistics;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class TaskCountBlockProcessor
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCountBlockProcessor.class);
    private final TaskCountStatistics taskMetrics;

    public TaskCountBlockProcessor(TaskCountStatistics taskMetrics) {
        Preconditions.checkNotNull((Object)taskMetrics);
        this.taskMetrics = taskMetrics;
    }

    public void destroy() throws Exception {
        AtomicLong tasks = this.taskMetrics.getTasks();
        while (tasks.get() > 0L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("{} more tasks have not been completed", (Object)tasks.get());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("OK, All task has been processed.");
        }
    }
}

