package com.bxm.warcar.integration.dc.dot;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.web.util.EncryptContext;
import com.bxm.warcar.web.util.aes.AesEncryptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;

/**
 * <h3>设备号汇总，目前业界常用的</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/10 16:12
 */
public class Device implements Serializable {
    private static Logger log = LoggerFactory.getLogger(Device.class);
    private static final long serialVersionUID = 3476161704906459589L;
    private static AesEncryptor aesEncryptor = new AesEncryptor();
    private static final String SIGN = "BXM";
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;

    public Device() {

    }

    public static Buider buider() {
        return new Buider();
    }

    /**
     * @return
     */
    public static String encrypt(Device device) {
        if (device == null) {
            return null;
        }

        try {
            return aesEncryptor.encrypt(new EncryptContext().setContent(JSON.toJSONString(device)).setKey(SIGN));
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    /**
     * @return
     */
    public static Device decrypt(String s) {
        if (StringUtils.isBlank(s)) {
            return new Device();
        }
        try {
            return JSON.parseObject((aesEncryptor.decrypt(new EncryptContext().setContent(s).setKey(SIGN))), Device.class);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return new Device();
    }


    private Device(String imei, String imeiMd5, String anid, String anidMd5, String oaid, String idfa, String idfaMd5) {
        this.imei = imei;
        this.imeiMd5 = imeiMd5;
        this.anid = anid;
        this.anidMd5 = anidMd5;
        this.oaid = oaid;
        this.idfa = idfa;
        this.idfaMd5 = idfaMd5;
    }

    @Override
    public String toString() {
        return "Device{" +
                "imei='" + imei + '\'' +
                ", imeiMd5='" + imeiMd5 + '\'' +
                ", anid='" + anid + '\'' +
                ", anidMd5='" + anidMd5 + '\'' +
                ", oaid='" + oaid + '\'' +
                ", idfa='" + idfa + '\'' +
                ", idfaMd5='" + idfaMd5 + '\'' +
                '}';
    }

    public static class Buider {
        /**
         * imei
         */
        private String imei;
        /**
         * imei md5
         */
        private String imeiMd5;
        /**
         * 安卓id
         */
        private String anid;
        /**
         * 安卓id md5
         */
        private String anidMd5;
        /**
         * 安全联盟定义的用户唯一标识OAID
         */
        private String oaid;
        /**
         * idfa
         */
        private String idfa;
        /**
         * idfa md5
         */
        private String idfaMd5;

        public Buider imei(String imei) {
            this.imei = imei;
            return this;
        }

        public Buider imeiMd5(String imeiMd5) {
            this.imeiMd5 = imeiMd5;
            return this;
        }

        public Buider anid(String anid) {
            this.anid = anid;
            return this;
        }

        public Buider anidMd5(String anidMd5) {
            this.anidMd5 = anidMd5;
            return this;
        }

        public Buider oaid(String oaid) {
            this.oaid = oaid;
            return this;
        }

        public Buider idfa(String idfa) {
            this.idfa = idfa;
            return this;
        }

        public Buider idfaMd5(String idfaMd5) {
            this.idfaMd5 = idfaMd5;
            return this;
        }

        public Device build() {
            return new Device(this.imei, this.imeiMd5, this.anid, this.anidMd5, this.oaid, this.idfa, this.idfaMd5);
        }
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public static void main(String[] args) {
        final Device device = Device.buider().imei("1").idfa("2").anid("3").anidMd5("4").idfaMd5("5").imeiMd5("6").oaid("7").build();
        System.out.println(device.getClass().getName()+":"+device);
        final String s = Device.encrypt(device);
        System.out.println(s);
        System.out.println(device.getClass().getName()+":"+Device.decrypt(s));
    }
}
