/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.eventbus.monitor;

import com.bxm.warcar.integration.eventbus.AsyncEventPark;
import com.bxm.warcar.message.Message;
import com.bxm.warcar.message.MessageSender;
import com.bxm.warcar.utils.LifeCycle;
import com.bxm.warcar.utils.NamedThreadFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncEventParkMonitor
extends LifeCycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncEventParkMonitor.class);
    private final ScheduledExecutorService consumeMonitor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("asyncEventPark-monitor"));
    private final AsyncEventPark asyncEventPark;
    private final int alarmQueueSize;
    private final MessageSender messageSender;

    public AsyncEventParkMonitor(AsyncEventPark asyncEventPark, int alarmQueueSize, MessageSender messageSender) {
        this.asyncEventPark = asyncEventPark;
        this.alarmQueueSize = alarmQueueSize;
        this.messageSender = messageSender;
    }

    protected void doInit() {
        this.consumeMonitor.scheduleWithFixedDelay(() -> {
            int size = this.asyncEventPark.getQueueSize();
            if (size > 0 && LOGGER.isInfoEnabled()) {
                LOGGER.info("The AsyncEventPark thread pool queue size is {}", (Object)size);
            }
            if (size >= this.alarmQueueSize && null != this.messageSender) {
                this.messageSender.send2(new Message(this.getIp() + " - AsyncEventPark \u5f53\u524d\u961f\u5217\u5806\u79ef\u91cf\uff1a" + size + " \u5df2\u8fbe\u5230\u62a5\u8b66\u7ebf\uff1a" + this.alarmQueueSize));
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    protected void doDestroy() {
        this.consumeMonitor.shutdownNow();
    }

    private String getIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getHostAddress();
        }
        catch (UnknownHostException e) {
            return "unknown";
        }
    }
}

