package com.bxm.warcar.integration.sifter;

import java.util.ArrayList;
import java.util.List;

/**
 * 筛选者链<br/>
 *
 * @author kerry.jiang
 * @date 2020/03/24 18:22
 */
public abstract class AbstractSifterChain {

    /**
     * 筛选者列表
     */
    protected List<AbstractSifter> sifterList = new ArrayList<>();
    
    /**
     * 筛选者执行过滤<br/>
     *
     * @param context 上下文数据
     * @return true:被过滤
     */
    public boolean doing(Context context){
        boolean filter = false;
        for (AbstractSifter sifter : this.sifterList){
            filter = sifter.filter(context);
            if(filter){
                //被过滤掉了
                break;
            }
        }
        if(!filter){
            context.addPassIdList();
        }
        return filter;
    }
}
