package com.bxm.warcar.integration.pushable;

import com.bxm.warcar.cache.push.Pushable;
import com.bxm.warcar.integration.pushable.annotation.CachePush;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ClassUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>缓存推送总控</p>
 * 如果需要将推送接收器集成到这个bus中，请将类实现{@linkplain Pushable}接口，并声明{@linkplain CachePush}
 *
 * @author allen
 * @date 2017-12-04
 */
public class CachePushableBus implements BeanPostProcessor {

    private static final Logger LOGGER = LoggerFactory.getLogger(CachePushableBus.class);

    private final Map<String, Pushable> pushables = new HashMap<>();

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class<?> beanClass = ClassUtils.getUserClass(bean);
        CachePush anno = beanClass.getAnnotation(CachePush.class);
        if (null != anno) {
            if (!(bean instanceof Pushable)) {
                throw new BeanCreationException("Bean '" + beanName + "' must be implement Pushable!");
            }
            pushables.put(anno.value(), (Pushable) bean);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Registering bean to CachePushableBus: {}", bean);
            }
        }
        return bean;
    }

    public Pushable getRefreshable(String serviceName) {
        return pushables.get(serviceName);
    }
}
