package com.bxm.warcar.integration.sifter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 被筛选的上下文数据<br/>
 *
 * @author kerry.jiang
 * @date 2020/03/24 18:11
 */
public class Context<T> implements java.io.Serializable {

    private static final long serialVersionUID = 88L;

    /**
     * 过滤消息
     */
    private SifterMessage message = new SifterMessage();
    /**
     * 唯一ID
     */
    private String id;
    /**
     * 业务数据
     */
    private T data;

    /**
     * 增加被通过的ID<br/>
     */
    void addPassIdList(){
        this.message.getPassIdList().add(this.id);
    }

    /**
     * 增加被过滤的原因<br/>
     *
     * @param className 筛选器类名
     * @param reason 过滤原因或代码
     */
    protected void addReason(String className, String reason) {
        Map<String, List<String>> msgMap = this.message.getReason().get(className);
        if(null == msgMap){
            msgMap = new HashMap<>();
            this.message.getReason().put(className, msgMap);
        }

        List<String> list = msgMap.get(reason);
        if(null == list){
            list = new ArrayList<>();
            msgMap.put(reason, list);
        }
        list.add(this.id);
        this.message.getNoPassIdList().add(this.id);
    }

    public SifterMessage getMessage() {
        return message;
    }

    public void setMessage(SifterMessage message) {
        this.message = message;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
