package com.bxm.warcar.integration.sifter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 筛选者<br/>
 *
 * @author kerry.jiang
 * @date 2020/03/24 18:12
 */
public abstract class AbstractSifter<T> {

    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSifter.class);

    /**
     * 添加被过滤的原因<br/>
     *
     * @param context 上下文数据
     * @param reason 过滤原因或代码
     * @return void
     */
    protected void addReason(Context<T> context, String reason) {
        String className = this.getClass().getName();
        context.addReason(className, reason);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[{}] {} remove {}.", className, reason, context.getId());
        }
    }

    /**
     * 条件过滤<br/>
     *
     * @param context 上下文数据
     * @return boolean true：过滤，false：不过滤
     */
    public abstract boolean filter(Context<T> context);
}
