package com.bxm.warcar.integration.dc.dot;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.web.util.EncryptContext;
import com.bxm.warcar.web.util.aes.AesEncryptor;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

/**
 * <h3>设备号汇总，目前业界常用的</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/11/10 16:12
 * @see com.bxm.warcar.utils.device.SimpleDevice
 * @deprecated 该加密方式不适用于URL作为参数传递，存在特殊字符。并且它默认使用了 json 序列化，数据字节浪费。
 * 建议使用 {@link com.bxm.warcar.utils.device.SimpleDevice}
 */
@Deprecated
public class Device implements Serializable {
    private static Logger log = LoggerFactory.getLogger(Device.class);
    private static final long serialVersionUID = 3476161704906459589L;
    private static AesEncryptor aesEncryptor = new AesEncryptor();
    private static final String SIGN = "BXM";
    /**
     * imei
     */
    private String imei;
    /**
     * imei md5
     */
    private String imeiMd5;
    /**
     * 安卓id
     */
    private String anid;
    /**
     * 安卓id md5
     */
    private String anidMd5;
    /**
     * 安全联盟定义的用户唯一标识OAID
     */
    private String oaid;
    /**
     * idfa
     */
    private String idfa;
    /**
     * idfa md5
     */
    private String idfaMd5;

    public Device() {

    }

    public static Buider buider() {
        return new Buider();
    }

    /**
     * @return
     */
    public static String encrypt(Device device) {
        if (device == null) {
            return null;
        }

        try {
            return aesEncryptor.encrypt(new EncryptContext().setContent(JSON.toJSONString(device)).setKey(SIGN));
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return null;
    }

    /**
     * @return
     */
    public static Device decrypt(String s) {
        if (StringUtils.isBlank(s)) {
            return new Device();
        }
        try {
            return JSON.parseObject((aesEncryptor.decrypt(new EncryptContext().setContent(s).setKey(SIGN))), Device.class);
        } catch (Exception e) {
            log.error(e.getMessage());
        }
        return new Device();
    }


    private Device(String imei, String imeiMd5, String anid, String anidMd5, String oaid, String idfa, String idfaMd5) {
        this.imei = imei;
        this.imeiMd5 = imeiMd5;
        this.anid = anid;
        this.anidMd5 = anidMd5;
        this.oaid = oaid;
        this.idfa = idfa;
        this.idfaMd5 = idfaMd5;
    }

    @Override
    public String toString() {
        return "Device{" +
                "imei='" + imei + '\'' +
                ", imeiMd5='" + imeiMd5 + '\'' +
                ", anid='" + anid + '\'' +
                ", anidMd5='" + anidMd5 + '\'' +
                ", oaid='" + oaid + '\'' +
                ", idfa='" + idfa + '\'' +
                ", idfaMd5='" + idfaMd5 + '\'' +
                '}';
    }

    public static class Buider {
        /**
         * imei
         */
        private String imei;
        /**
         * imei md5
         */
        private String imeiMd5;
        /**
         * 安卓id
         */
        private String anid;
        /**
         * 安卓id md5
         */
        private String anidMd5;
        /**
         * 安全联盟定义的用户唯一标识OAID
         */
        private String oaid;
        /**
         * idfa
         */
        private String idfa;
        /**
         * idfa md5
         */
        private String idfaMd5;

        public Buider imei(String imei) {
            this.imei = imei;
            return this;
        }

        public Buider imeiMd5(String imeiMd5) {
            this.imeiMd5 = imeiMd5;
            return this;
        }

        public Buider anid(String anid) {
            this.anid = anid;
            return this;
        }

        public Buider anidMd5(String anidMd5) {
            this.anidMd5 = anidMd5;
            return this;
        }

        public Buider oaid(String oaid) {
            this.oaid = oaid;
            return this;
        }

        public Buider idfa(String idfa) {
            this.idfa = idfa;
            return this;
        }

        public Buider idfaMd5(String idfaMd5) {
            this.idfaMd5 = idfaMd5;
            return this;
        }

        public Device build() {
            return new Device(this.imei, this.imeiMd5, this.anid, this.anidMd5, this.oaid, this.idfa, this.idfaMd5);
        }
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getImeiMd5() {
        return imeiMd5;
    }

    public void setImeiMd5(String imeiMd5) {
        this.imeiMd5 = imeiMd5;
    }

    public String getAnid() {
        return anid;
    }

    public void setAnid(String anid) {
        this.anid = anid;
    }

    public String getAnidMd5() {
        return anidMd5;
    }

    public void setAnidMd5(String anidMd5) {
        this.anidMd5 = anidMd5;
    }

    public String getOaid() {
        return oaid;
    }

    public void setOaid(String oaid) {
        this.oaid = oaid;
    }

    public String getIdfa() {
        return idfa;
    }

    public void setIdfa(String idfa) {
        this.idfa = idfa;
    }

    public String getIdfaMd5() {
        return idfaMd5;
    }

    public void setIdfaMd5(String idfaMd5) {
        this.idfaMd5 = idfaMd5;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String base64URLSafeString = Base64.encodeBase64URLSafeString("jasdfh237yf872h3f-==q-f=3qhu3f22".getBytes());
        System.out.println(base64URLSafeString);
        String base64String = Base64.encodeBase64String("jasdfh237yf872h3f-==q-f=3qhu3f22".getBytes());
        System.out.println(base64String);

        System.out.println(new String(Base64.decodeBase64(base64URLSafeString)));
        System.out.println(new String(Base64.decodeBase64(base64String)));
        System.out.println(new String(Base64.decodeBase64("NTJkZjc5YzJiMWQyOTkyZjM1YjU4MWE1NzhmNGYzZjFkMWQ2NjNlYTYxYTY0NjYwMjNmYTYzYWUzZjRjMmU3MjQzNGZmNTYzYTIxYWQyNDdhNjEwMjM2OTgzMmVkMTJhN2VjYzcyZmRmNGQ4OTgwODA5NzI1YzQxOWRhNzM4OTdjODE0ODZmNTUwNjkwZDk1MGM1NjJmZjI2OWJmMzhkNA==")));

        System.out.println(Device.decrypt(URLDecoder.decode("NTJkZjc5YzJiMWQyOTkyZjM1YjU4MWE1NzhmNGYzZjFkMWQ2NjNlYTYxYTY0NjYwMjNmYTYzYWUzZjRjMmU3MjQzNGZmNTYzYTIxYWQyNDdhNjEwMjM2OTgzMmVkMTJhN2VjYzcyZmRmNGQ4OTgwODA5NzI1YzQxOWRhNzM4OTdjODE0ODZmNTUwNjkwZDk1MGM1NjJmZjI2OWJmMzhkNA%3D%3D", "utf-8")));


        String s = Base64.encodeBase64URLSafeString("{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}".getBytes(StandardCharsets.UTF_8));
        System.out.println(s);
        String s1 = Base64.encodeBase64String("{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}{\"imei\":\"222635044556600\",\"imeiMd5\":\"6658dabd1a1ab4035e4ab69485f9cb59\"}".getBytes(StandardCharsets.UTF_8));
        System.out.println(s1);
        System.out.println(new String(Base64.decodeBase64(s), StandardCharsets.UTF_8));
        System.out.println(new String(Base64.decodeBase64(s1), StandardCharsets.UTF_8));
    }
}
