package com.bxm.warcar.integration.message.failover;

import com.bxm.warcar.mq.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 消息发送失败备援
 *
 * @author allen
 * @since 1.0.0
 */
public interface SendFailover {

    /**
     * 消息发送失败处理
     *
     * @param message 失败的消息对象
     * @param throwable 失败的异常
     */
    void doFail(Message message, Throwable throwable);

    class DefaultSendFailover implements SendFailover {

        private static final Logger LOGGER = LoggerFactory.getLogger(SendFailover.class);

        @Override
        public void doFail(Message message, Throwable throwable) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Send fail, message=[{}]", message);
                LOGGER.error("", throwable);
            }
        }
    }
}
