package com.bxm.warcar.integration.distributed.delayed;

import java.io.Serializable;

/**
 * 带延迟时间的任务执行器
 *
 * @param <V> 任务值类型
 */
public interface DelayedTaskExecutor<V extends Serializable> {

    /**
     * 执行任务
     *
     * @param value 待执行任务
     */
    default void accept(DelayedTask<V> value) {
    }

    /**
     * 拒绝任务
     *
     * @param value 待拒绝任务
     */
    default void reject(DelayedTask<V> value) {
    }
}
