package com.bxm.warcar.integration.distributed.lock;

import com.bxm.warcar.integration.distributed.DistributedLock;
import com.bxm.warcar.zk.ZkClientHolder;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @since 1.0.0
 */
public class ZooKeeperDistributedLock implements DistributedLock {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperDistributedLock.class);
    private final InterProcessLock lock;

    public ZooKeeperDistributedLock(ZkClientHolder zkClientHolder, String path) {
        this.lock = new InterProcessMutex(zkClientHolder.get(), path);
    }

    @Override
    public boolean acquire() {
        return this.acquire(0, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) {
        try {
            return lock.acquire(time, unit);
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public void release() {
        try {
            lock.release();
        } catch (Exception e) {
            LOGGER.error("release: ", e);
        }
    }
}
