/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.leader;

import com.bxm.warcar.integration.distributed.leader.LeaderSelectorExecutor;
import com.bxm.warcar.zk.ZkClientHolder;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class LeaderSelectorExecutorBeanFactory
implements BeanPostProcessor,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(LeaderSelectorExecutorBeanFactory.class);
    private final ZkClientHolder zkClientHolder;
    private final List<LeaderSelector> leaderSelectorList = Lists.newArrayList();

    public LeaderSelectorExecutorBeanFactory(ZkClientHolder zkClientHolder) {
        this.zkClientHolder = zkClientHolder;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        boolean assignableFrom = LeaderSelectorExecutor.class.isAssignableFrom(targetClass);
        if (assignableFrom) {
            LeaderSelectorExecutor leaderSelectorExecutor = (LeaderSelectorExecutor)bean;
            this.createLeaderSelectorAndStart(leaderSelectorExecutor);
        }
        return bean;
    }

    @Override
    public void close() {
        this.leaderSelectorList.forEach(LeaderSelector::close);
    }

    private void createLeaderSelectorAndStart(final LeaderSelectorExecutor leaderSelectorExecutor) {
        String className = leaderSelectorExecutor.getClass().getName();
        LeaderSelector leaderSelector = new LeaderSelector(this.zkClientHolder.get(), "/warcar/leader-selector/" + className, (LeaderSelectorListener)new LeaderSelectorListenerAdapter(){

            public void takeLeadership(CuratorFramework client) {
                try {
                    leaderSelectorExecutor.execute();
                }
                catch (Exception e) {
                    log.error("LeaderSelectorExecutor execute error", (Throwable)e);
                }
            }
        });
        this.leaderSelectorList.add(leaderSelector);
        try {
            leaderSelector.autoRequeue();
            leaderSelector.start();
            log.info("LeaderSelector {} start success", (Object)className);
        }
        catch (Exception e) {
            log.error("LeaderSelector {} start error", (Object)className, (Object)e);
        }
    }
}

