/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.integration.distributed.lock;

import com.bxm.warcar.integration.distributed.DistributedLock;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class RedissonDistributedLock
implements DistributedLock {
    private final RLock lock;

    public RedissonDistributedLock(RedissonClient redissonClient, String lockName) {
        this.lock = redissonClient.getLock(lockName);
    }

    @Override
    public boolean acquire() {
        return this.lock.tryLock();
    }

    @Override
    public boolean acquire(long time, TimeUnit unit) {
        try {
            return this.lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public void release() {
        this.lock.unlock();
    }
}

