/*
 * Copyright 2016 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * textile.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it only
 * in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */

package com.bxm.warcar.ip;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import java.beans.Transient;
import java.util.Set;

/**
 * <h3>IP</h3>
 *
 * @author allen
 * @since V1.0.0 2017/12/14
 */
public class IP {

    /**
     * 国家
     */
    private String country;
    /**
     * 省份
     */
    private String province;
    /**
     * 城市
     */
    private String city;
    /**
     * 区县
     */
    private String county;
    /**
     * 学校/单位/机关/部门
     */
    private String division;
    /**
     * 运营商
     */
    private String isp;
    /**
     * 运营商代码
     */
    private String ispcode;
    /**
     * 经度
     */
    private String longitude;
    /**
     * 纬度
     */
    private String latitude;
    /**
     * 时区 Asia/Shanghai
     */
    private String timezone;
    /**
     * UTC时区 UTC+8
     */
    private String utczone;
    /**
     * 国际电话代码
     */
    private String telphonenum;
    /**
     * 国家二位代码，如：CN
     */
    private String countrycode;

    /**
     * 定位到最小级别的行政区划代码，从区县到省份。如果只能识别到国家，那么则表示空。
     */
    private String hitcode;

    /**
     * 是否定位成功，必须定位到区县、城市或省份的才认为识别成功。
     * @return 定位成功
     */
    @Transient
    public boolean isHit() {
        return StringUtils.isNotBlank(this.getHitcode());
    }

    /**
     * <p>当前定位是否属于指定行政地区。</p>
     * <p>区县 属于 城市 属于 省份。</p>
     *
     * @param codes 指定行政地区
     * @return
     * <p>如果当前定位失败，那么会返回 false；</p>
     * <p>如果指定行政地区为空，那么会返回 false。</p>
     */
    @Transient
    public boolean in(Set<String> codes) {
        if (!isHit()) {
            return false;
        }
        if (CollectionUtils.isEmpty(codes)) {
            return false;
        }
        for (String code : codes) {
            // 区县、城市、省份逐级匹配
            if (StringUtils.equals(code, hitcode)
                    || StringUtils.equals(code, getCodeForCity(hitcode))
                    || StringUtils.equals(code, getCodeForProvince(hitcode))) {
                return true;
            }
        }
        return false;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getDivision() {
        return division;
    }

    public void setDivision(String division) {
        this.division = division;
    }

    public String getIsp() {
        return isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getIspcode() {
        return ispcode;
    }

    public void setIspcode(String ispcode) {
        this.ispcode = ispcode;
    }

    public String getLongitude() {
        return longitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getLatitude() {
        return latitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public String getTimezone() {
        return timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getUtczone() {
        return utczone;
    }

    public void setUtczone(String utczone) {
        this.utczone = utczone;
    }

    public String getTelphonenum() {
        return telphonenum;
    }

    public void setTelphonenum(String telphonenum) {
        this.telphonenum = telphonenum;
    }

    public String getCountrycode() {
        return countrycode;
    }

    public void setCountrycode(String countrycode) {
        this.countrycode = countrycode;
    }

    public String getHitcode() {
        return hitcode;
    }

    public void setHitcode(String hitcode) {
        this.hitcode = hitcode;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private String getCodeForProvince(String code) {
        return StringUtils.rightPad(StringUtils.left(code, 2), 6, "0");
    }

    private String getCodeForCity(String code) {
        return StringUtils.rightPad(StringUtils.left(code, 4), 6, "0");
    }
}
