package com.bxm.warcar.ip.impl.aliyun;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosRequest;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataInfosResponse;
import com.aliyuncs.geoip.model.v20200101.DescribeGeoipInstanceDataUrlRequest;
import com.aliyuncs.profile.DefaultProfile;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;

import java.util.List;
import java.util.Map;

/**
 * @author allen
 * @date 2022-04-18
 * @since 1.0
 */
public class AliyunDnsDataServerImpl implements DataServer {

    private final GeoipProfile profile;
    private final IAcsClient client;

    public AliyunDnsDataServerImpl(GeoipProfile profile) {
        this.profile = profile;
        this.client = new DefaultAcsClient(DefaultProfile.getProfile(profile.getRegionId(), profile.getAccessKeyId(), profile.getSecret()));
    }

    @Override
    public Map<Type, DataInfo> getDataInfos() throws Exception {
        DescribeGeoipInstanceDataInfosRequest request = new DescribeGeoipInstanceDataInfosRequest();
        request.setInstanceId(this.profile.getInstanceId());
        // 下载更全的 IP 库，在阿里云控制台下载的是精简版。
        request.putQueryParameter("LocationDataType", "TRACE");
        DescribeGeoipInstanceDataInfosResponse response = client.getAcsResponse(request);
        List<DescribeGeoipInstanceDataInfosResponse.DataInfo> dataInfos = response.getDataInfos();
        Map<Type, DataInfo> map = Maps.newHashMap();
        for (DescribeGeoipInstanceDataInfosResponse.DataInfo dataInfo : dataInfos) {
            for (Type value : Type.values()) {
                if (StringUtils.equalsIgnoreCase(value.name(), dataInfo.getType())) {
                    DataInfo df = new DataInfo();
                    df.setDownloadCount(dataInfo.getDownloadCount());
                    df.setType(dataInfo.getType());
                    df.setUpdateTime(dataInfo.getUpdateTime());
                    df.setUpdateTimestamp(dataInfo.getUpdateTimestamp());
                    df.setVersion(dataInfo.getVersion());
                    map.put(value, df);
                    break;
                }
            }
        }
        return map;
    }

    @Override
    public String getUrl(Type type) throws Exception {
        DescribeGeoipInstanceDataUrlRequest dr = new DescribeGeoipInstanceDataUrlRequest();
        dr.setInstanceId(this.profile.getInstanceId());
        dr.setDataType(type.name());
        return client.getAcsResponse(dr).getFixedDomainDownloadUrl();
    }
}
