/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.ip.impl.aliyun;

import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.ip.impl.aliyun.DataInfo;
import com.bxm.warcar.ip.impl.aliyun.DataServer;
import com.bxm.warcar.ip.impl.aliyun.Type;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class OssDataServerImpl
implements DataServer {
    private final String dataInfoUrl;
    private final String downloadUrl;
    private final HttpClient httpClient;

    public OssDataServerImpl(String dataInfoUrl, String downloadUrl) {
        this.dataInfoUrl = dataInfoUrl;
        this.downloadUrl = downloadUrl;
        this.httpClient = HttpClientBuilder.create().build();
    }

    @Override
    public Map<Type, DataInfo> getDataInfos() throws Exception {
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(this.dataInfoUrl));
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        HashMap res = Maps.newHashMap();
        Set keySet = jsonObject.keySet();
        for (String key : keySet) {
            Type type = Type.valueOf(key);
            DataInfo value = (DataInfo)jsonObject.getObject(key, DataInfo.class);
            res.put(type, value);
        }
        return res;
    }

    @Override
    public String getUrl(Type type) throws Exception {
        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet(this.downloadUrl));
        String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        JSONObject jsonObject = JSONObject.parseObject((String)body);
        return jsonObject.getString(type.name());
    }
}

