package com.bxm.warcar.message.test;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.*;

/**
 * @author allen
 * @since 2019-12-20
 */
@Slf4j
@RestController
@SpringBootApplication
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }

    @RequestMapping("/test/get")
    public String test1(@RequestHeader("h") String h,
                        @RequestParam("s") String s,
                        @RequestParam("i") Integer i){
        log.info("h={},i={},s={}",h,i,s);
        return "ok";
    }

    @RequestMapping("/test/post")
    public String postRequestBody(HttpProperties properties, @RequestHeader("h") String h){
        log.info("properties={},h={}", JSON.toJSONString(properties),h);
        return "ok";
    }

    @PostMapping("/postRequestBody1")
    public String postHeader1(@RequestBody HttpProperties properties){
        log.info("properties={}", JSON.toJSONString(properties));
        return "ok";
    }

    @PostMapping("/postRequestBody")
    public String postHeader(@RequestBody HttpProperties properties, @RequestHeader("h") String h){
        log.info("properties={},h={}", JSON.toJSONString(properties),h);
        return "ok";
    }
}
