/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.message.test;

import com.alibaba.fastjson.JSON;
import com.bxm.warcar.utils.http.properties.HttpProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@SpringBootApplication
public class Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @RequestMapping(value={"/test/get"})
    public String test1(@RequestHeader(value="h") String h, @RequestParam(value="s") String s, @RequestParam(value="i") Integer i) {
        log.info("h={},i={},s={}", new Object[]{h, i, s});
        return "ok";
    }

    @RequestMapping(value={"/test/post"})
    public String postRequestBody(HttpProperties properties, @RequestHeader(value="h") String h) {
        log.info("properties={},h={}", (Object)JSON.toJSONString((Object)properties), (Object)h);
        return "ok";
    }

    @PostMapping(value={"/postRequestBody1"})
    public String postHeader1(@RequestBody HttpProperties properties) {
        log.info("properties={}", (Object)JSON.toJSONString((Object)properties));
        return "ok";
    }

    @PostMapping(value={"/postRequestBody"})
    public String postHeader(@RequestBody HttpProperties properties, @RequestHeader(value="h") String h) {
        log.info("properties={},h={}", (Object)JSON.toJSONString((Object)properties), (Object)h);
        return "ok";
    }
}

