/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.voice.submail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.warcar.AbstractMessageSender;
import com.bxm.warcar.MessageException;
import com.bxm.warcar.voice.submail.Voice;
import com.bxm.warcar.voice.submail.VoiceSender;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.ResponseEntity;

public class SubmailSmsVoiceSender
extends AbstractMessageSender
implements VoiceSender {
    private static final String SUCCESS = "success";
    private final String appid;
    private final String appkey;
    private final String url;
    private final String project;

    public SubmailSmsVoiceSender(String appid, String appkey, String url, String project) {
        this.appid = appid;
        this.appkey = appkey;
        this.url = url;
        this.project = project;
    }

    @Override
    public void send(Voice voice) throws MessageException {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("appid", (Object)this.appid);
        jsonParam.put("multi", (Object)JSON.toJSONString(voice.getMulti()));
        jsonParam.put("signature", (Object)this.appkey);
        jsonParam.put("project", (Object)this.project);
        ResponseEntity<String> responseEntity = this.postForEntity(this.url, jsonParam);
        List bodys = JSONObject.parseArray((String)((String)responseEntity.getBody()), SendResult.class);
        if (CollectionUtils.isEmpty((Collection)bodys)) {
            throw new MessageException("result is null!");
        }
        for (SendResult body : bodys) {
            if (SUCCESS.equals(body.getStatus())) continue;
            throw new MessageException(JSONObject.toJSONString((Object)body), body.getStatus());
        }
    }

    public static void main(String[] args) {
        SubmailSmsVoiceSender sender = new SubmailSmsVoiceSender("21117", "847ebe942e6799deea966ff854c3d28f", "https://api.mysubmail.com/voice/multixsend.json", "V0FxW2");
        Voice voice = new Voice();
        voice.addMulti("17674750075");
        sender.send(voice);
    }

    public static class SendResult
    implements Serializable {
        private static final long serialVersionUID = -9083143317071986607L;
        private String status;
        private String to;
        private String send_id;
        private String money_account;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String getSend_id() {
            return this.send_id;
        }

        public void setSend_id(String send_id) {
            this.send_id = send_id;
        }

        public String getMoney_account() {
            return this.money_account;
        }

        public void setMoney_account(String money_account) {
            this.money_account = money_account;
        }
    }
}

