/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.metrics;

import com.bxm.warcar.metrics.ConsumeTimeMetric;
import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.boot.actuate.metrics.GaugeService;

public class DefaultConsumeTimeMetric
implements ConsumeTimeMetric {
    private final GaugeService gaugeService;
    private final ConcurrentMap<String, AtomicDouble> lastTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicDouble>();
    private final ConcurrentMap<String, AtomicDouble> largestTaskConsumeTimeTable = new ConcurrentHashMap<String, AtomicDouble>();

    public DefaultConsumeTimeMetric(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }

    @Override
    public void submit(String metricName, double value) {
        this.increaseTask(metricName, value);
        this.gaugeService.submit(metricName, value);
    }

    private void increaseTask(String serviceName, double consumingTime) {
        AtomicDouble lastTaskConsumeTime = this.lastTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicDouble(0.0));
        if (null == lastTaskConsumeTime) {
            lastTaskConsumeTime = (AtomicDouble)this.lastTaskConsumeTimeTable.get(serviceName);
        }
        lastTaskConsumeTime.set(consumingTime);
        AtomicDouble largestTimeContainer = this.largestTaskConsumeTimeTable.putIfAbsent(serviceName, new AtomicDouble(0.0));
        if (null == largestTimeContainer) {
            largestTimeContainer = (AtomicDouble)this.largestTaskConsumeTimeTable.get(serviceName);
        }
        this.processLargestTaskConsumeTime(largestTimeContainer, consumingTime);
    }

    private void processLargestTaskConsumeTime(AtomicDouble largestTimeContainer, double consumingTime) {
        int retry = 0;
        boolean done = false;
        do {
            long expect;
            if (!(consumingTime > (double)(expect = largestTimeContainer.longValue()))) continue;
            done = largestTimeContainer.compareAndSet((double)expect, consumingTime);
        } while (!done && ++retry < 3);
    }
}

