package com.bxm.warcar.micrometer.sentinel;

import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.bxm.warcar.utils.SafeMapHelper;
import io.micrometer.core.instrument.Tag;
import lombok.extern.slf4j.Slf4j;

import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;

/**
 * @author allen
 * @date 2022-03-31
 * @since 1.0
 */
@Slf4j
public class MicroMeterMetricExtension implements MetricExtension {

    private final ConcurrentHashMap<String, LongAdder> threadNumMap = new ConcurrentHashMap<>();

    @Override
    public void addPass(String resource, int n, Object... args) {
        SentinelMeter.counter("warcar.sentinel.pass", n, "resource", resource);
    }

    @Override
    public void addBlock(String resource, int n, String origin, BlockException blockException, Object... args) {
        SentinelMeter.counter("warcar.sentinel.block", n, "resource", resource);
    }

    @Override
    public void addSuccess(String resource, int n, Object... args) {
        SentinelMeter.counter("warcar.sentinel.success", n, "resource", resource);
    }

    @Override
    public void addException(String resource, int n, Throwable throwable) {
        SentinelMeter.counter("warcar.sentinel.exception", n, "resource", resource);
    }

    @Override
    public void addRt(String resource, long rt, Object... args) {
        SentinelMeter.timer("warcar.sentinel.rt", rt, "resource", resource);
    }

    @Override
    public void increaseThreadNum(String resource, Object... args) {
        SafeMapHelper.get(threadNumMap, resource, (SafeMapHelper.InitializingValue<LongAdder>) () -> {
            LongAdder adder = new LongAdder();
            Collection<Tag> tags = new HashSet<>();
            tags.add(Tag.of("resource", resource));
            SentinelMeter.gauge("warcar.sentinel.threadNum", tags, value -> adder.longValue());
            return adder;
        }).increment();
    }

    @Override
    public void decreaseThreadNum(String resource, Object... args) {
        if (!threadNumMap.containsKey(resource)) {
            log.warn("Not found gauge: {}", resource);
            return;
        }
        threadNumMap.get(resource).decrement();
    }
}
