/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.sentinel;

import com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.bxm.warcar.micrometer.sentinel.SentinelMeter;
import com.bxm.warcar.utils.SafeMapHelper;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroMeterMetricExtension
implements MetricExtension {
    private static final Logger log = LoggerFactory.getLogger(MicroMeterMetricExtension.class);
    private final ConcurrentHashMap<String, LongAdder> threadNumMap = new ConcurrentHashMap();

    public void addPass(String resource, int n, Object ... args) {
        SentinelMeter.counter("warcar.sentinel.pass", n, "resource", resource);
    }

    public void addBlock(String resource, int n, String origin, BlockException blockException, Object ... args) {
        SentinelMeter.counter("warcar.sentinel.block", n, "resource", resource);
    }

    public void addSuccess(String resource, int n, Object ... args) {
        SentinelMeter.counter("warcar.sentinel.success", n, "resource", resource);
    }

    public void addException(String resource, int n, Throwable throwable) {
        SentinelMeter.counter("warcar.sentinel.exception", n, "resource", resource);
    }

    public void addRt(String resource, long rt, Object ... args) {
        SentinelMeter.timer("warcar.sentinel.rt", rt, "resource", resource);
    }

    public void increaseThreadNum(String resource, Object ... args) {
        ((LongAdder)SafeMapHelper.get(this.threadNumMap, (Object)resource, () -> {
            LongAdder adder = new LongAdder();
            HashSet<Tag> tags = new HashSet<Tag>();
            tags.add(Tag.of((String)"resource", (String)resource));
            SentinelMeter.gauge("warcar.sentinel.threadNum", tags, value -> adder.longValue());
            return adder;
        })).increment();
    }

    public void decreaseThreadNum(String resource, Object ... args) {
        if (!this.threadNumMap.containsKey(resource)) {
            log.warn("Not found gauge: {}", (Object)resource);
            return;
        }
        this.threadNumMap.get(resource).decrement();
    }
}

