package com.bxm.warcar.micrometer.dpl;

import com.bxm.warcar.dpl2.PluginBus;
import com.bxm.warcar.dpl2.plugin.Plugin;
import com.bxm.warcar.dpl2.plugin.PluginConfig;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.Iterator;
import java.util.Objects;

/**
 * @author allen
 * @date 2020-10-29
 * @since 1.0
 */
public class PluginBusMeter implements MeterBinder {

    private final PluginBus pluginBus;

    public PluginBusMeter(PluginBus pluginBus) {
        this.pluginBus = pluginBus;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (Objects.isNull(pluginBus)) {
            return;
        }

        Gauge.builder("warcar.dpl.plugin", 0, value -> {
            Iterator<Plugin> allPlugins = pluginBus.getAllPlugins();
            int size = 0;
            while (allPlugins.hasNext()) {
                Plugin plugin = allPlugins.next();
                PluginConfig config = plugin.getConfig();
                config.getKey();
                size ++;
            }
            return size;
        }).tags("name", "size").register(registry);
    }
}
