/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.integration.eventbus;

import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodIntrospector;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class EventListenerMeter
implements MeterBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventListenerMeter.class);
    private final Map<Class, Timer> timer = Maps.newHashMap();
    private final Iterable<EventListener> eventListeners;

    public EventListenerMeter(Iterable<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public void bindTo(MeterRegistry registry) {
        for (EventListener eventListener : this.eventListeners) {
            Class targetClass = ClassUtils.getUserClass(eventListener.getClass());
            Set methods = MethodIntrospector.selectMethods((Class)targetClass, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                public boolean matches(Method method) {
                    return method.isAnnotationPresent(Subscribe.class);
                }
            });
            for (Method method : methods) {
                Object[] parameterTypes = method.getParameterTypes();
                if (ArrayUtils.isEmpty((Object[])parameterTypes)) continue;
                if (parameterTypes.length > 1 && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Method {} number of parameters must be 1", (Object)method);
                }
                Timer timer = Timer.builder((String)"warcar.integration.eventbus.listener").tags(new String[]{"name", targetClass.getName()}).tags(new String[]{"type", ((Class)parameterTypes[0]).getSimpleName()}).register(registry);
                this.timer.put(targetClass, timer);
            }
        }
    }

    Timer getTimer(EventListener eventListener) {
        return this.timer.get(ClassUtils.getUserClass(eventListener.getClass()));
    }
}

