/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.warcar.micrometer.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import com.bxm.warcar.micrometer.ip.IpLibraryMeter;
import io.micrometer.core.instrument.Timer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class IpLibraryMeterAspect {
    private final IpLibraryMeter ipLibraryMeter;

    public IpLibraryMeterAspect(IpLibraryMeter ipLibraryMeter) {
        this.ipLibraryMeter = ipLibraryMeter;
    }

    @Pointcut(value="this(com.bxm.warcar.ip.IpLibrary)")
    public void pointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof IpLibrary)) {
            return point.proceed();
        }
        String name = point.getSignature().getName();
        if (!StringUtils.equals((String)name, (String)"find")) {
            return point.proceed();
        }
        IpLibrary library = (IpLibrary)target;
        Timer timer = this.ipLibraryMeter.getTimer(library);
        long start = System.nanoTime();
        try {
            this.ipLibraryMeter.incrementTotal(library);
            Object o = point.proceed();
            if (o instanceof IP && ((IP)o).isHit()) {
                this.ipLibraryMeter.incrementSuccess(library);
            }
            Object object = o;
            return object;
        }
        finally {
            if (Objects.nonNull(timer)) {
                timer.record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            }
        }
    }
}

