package com.bxm.warcar.micrometer.datasync;

import com.bxm.warcar.datasync.client.cache.Cache;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.util.ClassUtils;

/**
 * @author allen
 * @date 2019/6/20
 * @since 1.0.0
 */
public class CacheMeter implements MeterBinder {

    private final Iterable<Cache> caches;

    public CacheMeter(Iterable<Cache> caches) {
        this.caches = caches;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        for (Cache cache : caches) {
            FunctionCounter.builder("warcar.datasync.cache", 0, value -> cache.size())
                    .tags("class", ClassUtils.getUserClass(cache).getSimpleName()).register(registry);
        }
    }
}
