package com.bxm.warcar.micrometer.ip;

import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import io.micrometer.core.instrument.Timer;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * @author allen
 * @date 2021-04-28
 * @since 1.0
 */
@Aspect
public class IpLibraryMeterAspect {

    private final IpLibraryMeter ipLibraryMeter;

    public IpLibraryMeterAspect(IpLibraryMeter ipLibraryMeter) {
        this.ipLibraryMeter = ipLibraryMeter;
    }

    @Pointcut("this(com.bxm.warcar.ip.IpLibrary)")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof IpLibrary)) {
            return point.proceed();
        }
        String name = point.getSignature().getName();
        if (!StringUtils.equals(name, "find")) {
            return point.proceed();
        }
        IpLibrary library = (IpLibrary) target;
        Timer timer = ipLibraryMeter.getTimer(library);
        long start = System.nanoTime();
        try {
            ipLibraryMeter.incrementTotal(library);
            Object o = point.proceed();
            if (o instanceof IP) {
                if (((IP) o).isHit()) {
                    ipLibraryMeter.incrementSuccess(library);
                }
            }
            return o;
        } finally {
            if (Objects.nonNull(timer)) {
                timer.record((System.nanoTime() - start), TimeUnit.NANOSECONDS);
            }
        }
    }
}
