package com.bxm.warcar.micrometer.mq;

import com.bxm.warcar.mq.Producer;
import com.bxm.warcar.mq.Type;
import io.micrometer.core.instrument.Timer;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * 消息生产者切面
 * @author allen
 * @date 2019/6/20
 * @since 1.0.0
 */
@Aspect
public class ProducerMeterAspect {

    private final ProducerMeter producerMeter;

    public ProducerMeterAspect(ProducerMeter producerMeter) {
        this.producerMeter = producerMeter;
    }

    @Pointcut("this(com.bxm.warcar.mq.Producer)")
    public void pointcut() {}

    @Around("pointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object target = point.getTarget();
        if (!(target instanceof Producer)) {
            return point.proceed();
        }

        Type type = ((Producer) target).getType();
        Timer timer = producerMeter.getTimer(type);
        long start = System.nanoTime();
        try {
            return point.proceed();
        } finally {
            if (Objects.nonNull(timer)) {
                timer.record((System.nanoTime() - start), TimeUnit.NANOSECONDS);
            }
        }
    }
}
