package com.bxm.warcar.mq.kafka;

import com.bxm.warcar.mq.Consumer;
import com.bxm.warcar.mq.Listener;
import com.bxm.warcar.utils.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Properties;

/**
 * <code>Beta</code>
 * @author allen
 * @since 1.0.0
 */
public class KafkaConsumer extends LifeCycle implements Consumer {

    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaConsumer.class);
    private final Listener listener;
    private int consumeTimeOutInMillis = 100;
    private org.apache.kafka.clients.consumer.Consumer<String, byte[]> consumer;

    public KafkaConsumer(Properties properties, Listener listener) {
        this.listener = listener;
        this.consumer = new org.apache.kafka.clients.consumer.KafkaConsumer<String, byte[]>(properties);
    }

    @Override
    protected void doInit() {
        String topic = getMessageListener().getTopic();

    }

    @Override
    protected void doDestroy() {

    }

    @Override
    public void suspend() {

    }

    @Override
    public void shutdown() {
        if (null != this.consumer) {
            this.consumer.close();
        }
    }

    @Override
    public void start() {

    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public Listener getMessageListener() {
        return this.listener;
    }

    public int getConsumeTimeOutInMillis() {
        return consumeTimeOutInMillis;
    }

    public void setConsumeTimeOutInMillis(int consumeTimeOutInMillis) {
        this.consumeTimeOutInMillis = consumeTimeOutInMillis;
    }
}
